---
name: t.rast.contour.py
description: Produces a space time vector dataset of specified contours from a space time raster dataset.
keywords: [ temporal, contour, raster, vector, time ]
---

# t.rast.contour.py

Produces a space time vector dataset of specified contours from a space time raster dataset.

=== "Command line"

    **t.rast.contour.py**
    [**-nt**]
    **input**=*name*
    **output**=*name*
    [**where**=*sql_query*]
    **basename**=*string*
    [**suffix**=*string*]
    [**step**=*float*]
    [**levels**=*float* [,*float*,...]]
    [**minlevel**=*float*]
    [**maxlevel**=*float*]
    [**cut**=*integer*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.contour.py input=name output=name basename=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.contour.py***",
        **input**,
        **output**,
        **where**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **step**=*None*,
        **levels**=*None*,
        **minlevel**=*None*,
        **maxlevel**=*None*,
        **cut**=*0*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.contour.py", input="name", output="name", basename="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_contour_py*(**input**,
        **output**,
        **where**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **step**=*None*,
        **levels**=*None*,
        **minlevel**=*None*,
        **maxlevel**=*None*,
        **cut**=*0*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_contour_py(input="name", output="name", basename="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **basename**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Increment between contour levels  
    **levels**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of contour levels  
    **minlevel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum contour level  
    **maxlevel**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum contour level  
    **cut**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points for a contour line (0 -&gt; no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.contour processes to run in parallel, more than 1 process works only in conjunction with flag -t  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register empty vector maps  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute tables  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stvds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Increment between contour levels  
    **levels** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of contour levels  
    **minlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum contour level  
    **maxlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum contour level  
    **cut** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points for a contour line (0 -&gt; no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.contour processes to run in parallel, more than 1 process works only in conjunction with flag -t  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register empty vector maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute tables  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stvds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Increment between contour levels  
    **levels** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of contour levels  
    **minlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum contour level  
    **maxlevel** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum contour level  
    **cut** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points for a contour line (0 -&gt; no limit)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.contour processes to run in parallel, more than 1 process works only in conjunction with flag -t  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register empty vector maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute tables  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.contour* is designed to produce a space time vector dataset of
specified contours from a space time raster dataset. This module works
as a front-end to [r.contour](r.contour.md) and therefore supports all
parameter of this module. Hence, all raster map layers in a space time
raster dataset are successively passed to [r.contour](r.contour.md) that
computes the contour lines. Please refer to the
[r.contour](r.contour.md) documentation for a detailed description. The
new generated vector contour map layers will be registered in the output
space time vector dataset, using the same time stamps as their raster
map layer origins.

This module supports the parallel processing of
[r.contour](r.contour.md) module instances. The number of parallel
processes can be set with the *nprocs* option. However, this will only
work in conjunction with the *-t* flag, that avoids the creation of
attribute tables. The parallel creation of attribute tables is not
supported.

The *where* option allows selecting subsets of the input space time
raster dataset.

The flag *-n* can be used to force the registration of empty vector map
layers. Empty vector maps may occur in case that empty raster map layers
should be converted into vector map layers, or in case the chosen steps
or contour levels are not present in the raster map layers.

## SEE ALSO

*[r.contour](r.contour.md), [t.rast.db.select](t.vect.db.select.md),
[t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Geoinformatikbüro Dassau

## SOURCE CODE

Available at: [t.rast.contour source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.contour)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.contour))  
Latest change: Saturday Mar 01 11:59:08 2025 in commit [d310a3c](https://github.com/OSGeo/grass/commit/d310a3c28e84eff31e2d2c9f8c6218ba71dd40b8)
