---
name: t.rast.kappa.py
description: Calculate kappa parameter in a space time raster dataset
keywords: [ temporal, raster, statistics ]
---

# t.rast.kappa.py

Calculate kappa parameter in a space time raster dataset

=== "Command line"

    **t.rast.kappa.py**
    [**-klp**]
    **strds**=*name*
    [**output**=*name*]
    [**weight**=*string*]
    [**where**=*sql_query*]
    [**splittingday**=*string*]
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.kappa.py strds=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.kappa.py***",
        **strds**,
        **output**=*"-"*,
        **weight**=*None*,
        **where**=*None*,
        **splittingday**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.kappa.py", strds="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_kappa_py*(**strds**,
        **output**=*"-"*,
        **weight**=*None*,
        **where**=*None*,
        **splittingday**=*None*,
        **separator**=*"pipe"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_kappa_py(strds="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **strds**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output file or "-" in case stdout should be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **weight**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specifies the weight matrix for the calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear,  quadratic*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **splittingday**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specifies the day to split the space time raster dataset in two groups, isotime format  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use r.kappa module instead SciKit-Learn Laboratory metrics.kappa  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use memory swap  
  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pixel by pixel analysis along different years  
  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **strds** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output file or "-" in case stdout should be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **weight** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specifies the weight matrix for the calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear,  quadratic*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **splittingday** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specifies the day to split the space time raster dataset in two groups, isotime format  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *l*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use r.kappa module instead SciKit-Learn Laboratory metrics.kappa  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use memory swap  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pixel by pixel analysis along different years  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **strds** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output file or "-" in case stdout should be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **weight** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specifies the weight matrix for the calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *linear,  quadratic*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **splittingday** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Specifies the day to split the space time raster dataset in two groups, isotime format  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *l*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use r.kappa module instead SciKit-Learn Laboratory metrics.kappa  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use memory swap  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pixel by pixel analysis along different years  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The t.rast.kappa calculate kappa parameter in a space time raster
dataset. It can calculate kappa values using two different algorithm,
the one provided by
[r.kappa](https://grass.osgeo.org/grass-stable/manuals/r.kappa.html) and
the one provided by [SciKit-Learn
metrics](https://scikit-learn.org/stable/modules/generated/sklearn.metrics.cohen_kappa_score.html)
library

## EXAMPLE

### Using r.kappa as backend

In this example t.rast.kappa is using
[r.kappa](https://grass.osgeo.org/grass-stable/manuals/r.kappa.html) as
backend, it return the results inside the */tmp*em\> directory into
files with *mystrds* as prefix. *weight* option is not considered using
[r.kappa](https://grass.osgeo.org/grass-stable/manuals/r.kappa.html) as
backend.

```sh
        t.rast.kappa -k strds=mystrds output=/tmp/mystrds
    
```

### Using SciKit-Learn as backend, text as output

In this example t.rast.kappa is using [SciKit-Learn
metrics](https://scikit-learn.org/stable/modules/generated/sklearn.metrics.cohen_kappa_score.html)
library as backend, without *output* option, the module print the
results to standard output

```sh
        t.rast.kappa strds=mystrds where="start_time >= '1999-12-01' weight='linear'
    
```

### Using SciKit-Learn as backend, map as output

In this example t.rast.kappa is using [SciKit-Learn
metrics](https://scikit-learn.org/stable/modules/generated/sklearn.metrics.cohen_kappa_score.html)
library as backend, the output is a map with the kappa values calculated
for each pixel. The *splittingday* option is required to split the space
time raster dataset in two groups and analyze them; the two groups must
have the same number of maps, otherwise and error will be reported.

```sh
        t.rast.kappa -p strds=mystrds output=mykappa splittingday='2005-01-01'
    
```

## SEE ALSO

[r.kappa](https://grass.osgeo.org/grass-stable/manuals/r.kappa.html)

## AUTHOR

Luca Delucchi, *Fondazione Edmund Mach*

## SOURCE CODE

Available at: [t.rast.kappa source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/temporal/t.rast.kappa)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/temporal/t.rast.kappa))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
