---
name: t.rast.out.vtk.py
description: Exports space time raster dataset as VTK time series.
keywords: [ temporal, export, output, raster, VTK, time ]
---

# t.rast.out.vtk.py

Exports space time raster dataset as VTK time series.

=== "Command line"

    **t.rast.out.vtk.py**
    [**-pcg**]
    **input**=*name*
    **directory**=*string*
    [**elevation**=*name*]
    [**where**=*sql_query*]
    [**null**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.out.vtk.py input=name directory=string
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***t.rast.out.vtk.py***",
        **input**,
        **directory**,
        **elevation**=*None*,
        **where**=*None*,
        **null**=*-99999.99*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("t.rast.out.vtk.py", input="name", directory="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_out_vtk_py*(**input**,
        **directory**,
        **elevation**=*None*,
        **where**=*None*,
        **null**=*-99999.99*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_out_vtk_py(input="name", directory="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **directory**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the export directory  
    **elevation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to represent no data cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-99999.99*  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create VTK point data instead of VTK cell data (if no elevation map is given)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Correct the coordinates to fit the VTK-OpenGL precision  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export files using the space time dataset granularity for equidistant time between maps, where statement will be ignored  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the export directory  
    **elevation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to represent no data cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-99999.99*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *c*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create VTK point data instead of VTK cell data (if no elevation map is given)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Correct the coordinates to fit the VTK-OpenGL precision  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export files using the space time dataset granularity for equidistant time between maps, where statement will be ignored  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the export directory  
    **elevation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to represent no data cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-99999.99*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *c*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create VTK point data instead of VTK cell data (if no elevation map is given)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Correct the coordinates to fit the VTK-OpenGL precision  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export files using the space time dataset granularity for equidistant time between maps, where statement will be ignored  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.out.vtk* exports all maps registered in a space time raster
datasets as VTK legacy files using a numerical numbering scheme. The VTK
files can be visualized with any VTK based visualize. Our preferred tool
is ParaView. The VTK legacy files are created using **r.out.vtk**.

## EXAMPLE

In this simple example we create several raster maps with random values
and one elevation map. The random value raster maps are registered in a
space time raster dataset. All maps of this space time raster dataset
are exported using **t.rast.out.vtk** into the directory
**/tmp/export**.

```sh
mkdir /tmp/export
t.rast.out.vtk input=precip_abs directory=/tmp/export/ elevation=elevation

ls -1 /tmp/export
000000_tempmean_monthly.vtk
000001_tempmean_monthly.vtk
000002_tempmean_monthly.vtk
000003_tempmean_monthly.vtk
000004_tempmean_monthly.vtk
000005_tempmean_monthly.vtk
000006_tempmean_monthly.vtk
000007_tempmean_monthly.vtk
000008_tempmean_monthly.vtk
000009_tempmean_monthly.vtk
000010_tempmean_monthly.vtk
000011_tempmean_monthly.vtk
```

## SEE ALSO

*[r.out.vtk](r.out.vtk.md), [ParaView](https://www.paraview.org)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.out.vtk source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.out.vtk)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.out.vtk))  
Latest change: Tuesday Oct 21 09:57:14 2025 in commit [fb0165c](https://github.com/OSGeo/grass/commit/fb0165c2d021b7700528aca09c224847be871729)
