---
name: t.rast3d.list.py
description: Lists registered maps of a space time raster3d dataset.
keywords: [ temporal, map management, list, raster3d, voxel, time ]
---

# t.rast3d.list.py

Lists registered maps of a space time raster3d dataset.

=== "Command line"

    **t.rast3d.list.py**
    [**-s**]
    **input**=*name*
    [**order**=*string* [,*string*,...]]
    [**columns**=*string* [,*string*,...]]
    [**where**=*sql_query*]
    [**method**=*string*]
    [**separator**=*character*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast3d.list.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast3d.list.py***",
        **input**,
        **order**=*"start_time"*,
        **columns**=*"name,mapset,start_time,end_time"*,
        **where**=*None*,
        **method**=*"cols"*,
        **separator**=*"pipe"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast3d.list.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast3d_list_py*(**input**,
        **order**=*"start_time"*,
        **columns**=*"name,mapset,start_time,end_time"*,
        **where**=*None*,
        **method**=*"cols"*,
        **separator**=*"pipe"*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast3d_list_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d dataset  
    **order**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Order the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, nsres, tbres, ewres, cols, rows, depths, number_of_cells, min, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start_time*  
    **columns**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, nsres, tbres, ewres, cols, rows, depths, number_of_cells, min, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *name,mapset,start_time,end_time*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for data listing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cols, comma, delta, deltagaps, gran*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cols*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, str3ds, *name*  
    **order** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Order the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, nsres, tbres, ewres, cols, rows, depths, number_of_cells, min, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start_time*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, nsres, tbres, ewres, cols, rows, depths, number_of_cells, min, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *name,mapset,start_time,end_time*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for data listing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cols, comma, delta, deltagaps, gran*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cols*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, str3ds, *name*  
    **order** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Order the space time dataset by category  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, nsres, tbres, ewres, cols, rows, depths, number_of_cells, min, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start_time*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Columns to be printed to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *id, name, creator, mapset, temporal_type, creation_time, start_time, end_time, north, south, west, east, nsres, tbres, ewres, cols, rows, depths, number_of_cells, min, max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *name,mapset,start_time,end_time*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method used for data listing  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cols, comma, delta, deltagaps, gran*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *cols*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator character between the output columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of column names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast3d.list* provides the same functionality as
[t.rast.list](t.rast.list.md), the only difference is the 3D raster map
layer metadata. Please refer to the manual page of
[t.rast.list](t.rast.list.md).

## SEE ALSO

*[t.rast.list](t.rast.list.md), [g.list](g.list.md),
[t.create](t.create.md), [t.info](t.info.md), [t.list](t.list.md),
[t.vect.list](t.vect.list.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast3d.list source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast3d.list)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast3d.list))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
