---
name: t.shift.py
description: Shifts temporally the maps of a space time dataset.
keywords: [ temporal, time management, shift, time ]
---

# t.shift.py

Shifts temporally the maps of a space time dataset.

=== "Command line"

    **t.shift.py**
    **input**=*name*
    [**type**=*name*]
    **granularity**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.shift.py input=name granularity=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.shift.py***",
        **input**,
        **type**=*"strds"*,
        **granularity**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.shift.py", input="name", granularity="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_shift_py*(**input**,
        **type**=*"strds"*,
        **granularity**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_shift_py(input="name", granularity="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing space time dataset  
    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **granularity**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift granularity  
    &nbsp;&nbsp;&nbsp;&nbsp;Format absolute time: "x years, x months, x weeks, x days, x hours, x minutes, x seconds", relative time is of type integer  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **granularity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift granularity  
    &nbsp;&nbsp;&nbsp;&nbsp;Format absolute time: "x years, x months, x weeks, x days, x hours, x minutes, x seconds", relative time is of type integer  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **granularity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift granularity  
    &nbsp;&nbsp;&nbsp;&nbsp;Format absolute time: "x years, x months, x weeks, x days, x hours, x minutes, x seconds", relative time is of type integer  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.shift* is designed to temporally shift all registered maps in a space
time dataset with a user defined granularity. Raster, 3D raster and
vector space time datasets are supported.

The format of the absolute time granularity is "number unit". Number is
an integer, unit is the temporal unit that can be one of year(s),
month(s), week(s), day(s), hour(s), minute(s) or second(s).

The granularity in case of relative time is an integer. The temporal
unit is the unit of the space time dataset and can not be modified.

## NOTES

Be careful when shifting space time datasets with absolute time. The
temporal granularity may change if you shift a space time dataset with a
unit that is different from the space time dataset granularity. Be aware
that the shifting with months and years may result in incorrect days per
month. Shifting the date 20012-03-31 with a granularity of one month
will result in 2012-04-31 which is incorrect. In this case an error will
raise and the shifting will not performed for the whole dataset.

You can use the extraction module to shift only a subset of maps from a
space time dataset. Be aware that the shifting of maps affect all space
time datasets in which they are registered.

## EXAMPLE

We create 6 raster maps and register them in a space time raster dataset
using an increment of one day. Then we shift the time intervals with a
granularity of 12 hours.

```sh
r.mapcalc expression="prec_1 = rand(0, 550)" -s
r.mapcalc expression="prec_2 = rand(0, 450)" -s
r.mapcalc expression="prec_3 = rand(0, 320)" -s
r.mapcalc expression="prec_4 = rand(0, 510)" -s
r.mapcalc expression="prec_5 = rand(0, 300)" -s
r.mapcalc expression="prec_6 = rand(0, 650)" -s

t.create type=strds temporaltype=absolute \
         output=precipitation_daily \
         title="Daily precipitation" \
         description="Test dataset with daily precipitation"

t.register -i type=raster input=precipitation_daily \
           maps=prec_1,prec_2,prec_3,prec_4,prec_5,prec_6 \
           start=2012-01-01 increment="1 day"

t.info type=strds input=precipitation_daily

 +-------------------- Space Time Raster Dataset -----------------------------+
 |                                                                            |
 +-------------------- Basic information -------------------------------------+
 | Id: ........................ precipitation_daily@PERMANENT
 | Name: ...................... precipitation_daily
 | Mapset: .................... PERMANENT
 | Creator: ................... soeren
 | Temporal type: ............. absolute
 | Creation time: ............. 2014-11-23 19:20:26.004855
 | Modification time:.......... 2014-11-23 19:20:26.471536
 | Semantic type:.............. mean
 +-------------------- Absolute time -----------------------------------------+
 | Start time:................. 2012-01-01 00:00:00
 | End time:................... 2012-01-07 00:00:00
 | Granularity:................ 1 day
 | Temporal type of maps:...... interval
 +-------------------- Spatial extent ----------------------------------------+
 | North:...................... 80.0
 | South:...................... 0.0
 | East:.. .................... 120.0
 | West:....................... 0.0
 | Top:........................ 0.0
 | Bottom:..................... 0.0
 +-------------------- Metadata information ----------------------------------+
 | Raster register table:...... raster_map_register_882043e9afaa4e60b845aceb1a1fee2c
 | North-South resolution min:. 10.0
 | North-South resolution max:. 10.0
 | East-west resolution min:... 10.0
 | East-west resolution max:... 10.0
 | Minimum value min:.......... 0.0
 | Minimum value max:.......... 16.0
 | Maximum value min:.......... 297.0
 | Maximum value max:.......... 647.0
 | Aggregation type:........... None
 | Number of registered maps:.. 6
 |
 | Title:
 | Daily precipitation
 | Description:
 | Test dataset with daily precipitation
 | Command history:
 | # 2014-11-23 19:20:26
 | t.create type="strds" temporaltype="absolute"
 |     output="precipitation_daily" title="Daily precipitation"
 |     description="Test dataset with daily precipitation"
 | # 2014-11-23 19:20:26
 | t.register -i type="rast" input="precipitation_daily"
 |     maps="prec_1,prec_2,prec_3,prec_4,prec_5,prec_6" start="2012-01-01"
 |     increment="1 day"
 |
 +----------------------------------------------------------------------------+

t.rast.list input=precipitation_daily

name|mapset|start_time|end_time
prec_1|PERMANENT|2012-01-01 00:00:00|2012-01-02 00:00:00
prec_2|PERMANENT|2012-01-02 00:00:00|2012-01-03 00:00:00
prec_3|PERMANENT|2012-01-03 00:00:00|2012-01-04 00:00:00
prec_4|PERMANENT|2012-01-04 00:00:00|2012-01-05 00:00:00
prec_5|PERMANENT|2012-01-05 00:00:00|2012-01-06 00:00:00
prec_6|PERMANENT|2012-01-06 00:00:00|2012-01-07 00:00:00


t.shift type=strds input=precipitation_daily granularity="12 hours"

t.info type=strds input=precipitation_daily

 +-------------------- Space Time Raster Dataset -----------------------------+
 |                                                                            |
 +-------------------- Basic information -------------------------------------+
 | Id: ........................ precipitation_daily@PERMANENT
 | Name: ...................... precipitation_daily
 | Mapset: .................... PERMANENT
 | Creator: ................... soeren
 | Temporal type: ............. absolute
 | Creation time: ............. 2014-11-23 19:20:26.004855
 | Modification time:.......... 2014-11-23 19:21:08.240018
 | Semantic type:.............. mean
 +-------------------- Absolute time -----------------------------------------+
 | Start time:................. 2012-01-01 12:00:00
 | End time:................... 2012-01-07 12:00:00
 | Granularity:................ 24 hours
 | Temporal type of maps:...... interval
 +-------------------- Spatial extent ----------------------------------------+
 | North:...................... 80.0
 | South:...................... 0.0
 | East:.. .................... 120.0
 | West:....................... 0.0
 | Top:........................ 0.0
 | Bottom:..................... 0.0
 +-------------------- Metadata information ----------------------------------+
 | Raster register table:...... raster_map_register_882043e9afaa4e60b845aceb1a1fee2c
 | North-South resolution min:. 10.0
 | North-South resolution max:. 10.0
 | East-west resolution min:... 10.0
 | East-west resolution max:... 10.0
 | Minimum value min:.......... 0.0
 | Minimum value max:.......... 16.0
 | Maximum value min:.......... 297.0
 | Maximum value max:.......... 647.0
 | Aggregation type:........... None
 | Number of registered maps:.. 6
 |
 | Title:
 | Daily precipitation
 | Description:
 | Test dataset with daily precipitation
 | Command history:
 | # 2014-11-23 19:20:26
 | t.create type="strds" temporaltype="absolute"
 |     output="precipitation_daily" title="Daily precipitation"
 |     description="Test dataset with daily precipitation"
 | # 2014-11-23 19:20:26
 | t.register -i type="rast" input="precipitation_daily"
 |     maps="prec_1,prec_2,prec_3,prec_4,prec_5,prec_6" start="2012-01-01"
 |     increment="1 day"
 | # 2014-11-23 19:21:08
 | t.shift type="strds" input="precipitation_daily"
 |     granularity="12 hours"
 |
 +----------------------------------------------------------------------------+


t.rast.list input=precipitation_daily

name|mapset|start_time|end_time
prec_1|PERMANENT|2012-01-01 12:00:00|2012-01-02 12:00:00
prec_2|PERMANENT|2012-01-02 12:00:00|2012-01-03 12:00:00
prec_3|PERMANENT|2012-01-03 12:00:00|2012-01-04 12:00:00
prec_4|PERMANENT|2012-01-04 12:00:00|2012-01-05 12:00:00
prec_5|PERMANENT|2012-01-05 12:00:00|2012-01-06 12:00:00
prec_6|PERMANENT|2012-01-06 12:00:00|2012-01-07 12:00:00
```

## SEE ALSO

*[t.create](t.create.md), [t.register](t.register.md),
[t.snap](t.snap.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.shift source code](https://github.com/OSGeo/grass/tree/main/temporal/t.shift)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.shift))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
