---
hide:
  - toc
---

# Topic: geometry

| Tool | Description |
|--------|-------------|
| [i.image.mosaic](i.image.mosaic.md) | Mosaics several images and extends colormap. |
| [r.patch](r.patch.md) | Creates a composite raster map layer by using known category values from one (or more) map layer(s) to fill in areas of "no data" in another map layer. |
| [r.thin](r.thin.md) | Thins non-null cells that denote linear features in a raster map layer. |
| [v.delaunay](v.delaunay.md) | Creates a Delaunay triangulation from an input vector map containing points or centroids. |
| [v.drape](v.drape.md) | Converts 2D vector features to 3D by sampling of elevation raster map. |
| [v.edit](v.edit.md) | Edits a vector map, allows adding, deleting and modifying selected vector features. |
| [v.extrude](v.extrude.md) | Extrudes flat vector features to 3D vector features with defined height. Optionally the height can be derived from sampling of elevation raster map. |
| [v.fill.holes](v.fill.holes.md) | Fill holes in areas by keeping only outer boundaries |
| [v.hull](v.hull.md) | Produces a 2D/3D convex hull for a given vector map. |
| [v.in.region](v.in.region.md) | Creates a vector polygon from the current region extent. |
| [v.mkgrid](v.mkgrid.md) | Creates a vector map of a user-defined grid. |
| [v.overlay](v.overlay.md) | Overlays two vector maps offering clip, intersection, difference, symmetrical difference, union operators. |
| [v.parallel](v.parallel.md) | Creates parallel line to input vector lines. |
| [v.patch](v.patch.md) | Creates a new vector map by combining other vector maps. |
| [v.perturb](v.perturb.md) | Random location perturbations of vector points. |
| [v.report](v.report.md) | Reports geometry statistics for vector maps. |
| [v.segment](v.segment.md) | Creates points/segments from input vector lines and positions. |
| [v.select](v.select.md) | Selects features from vector map (A) by features from other vector map (B). |
| [v.split](v.split.md) | Splits vector lines to shorter segments. |
| [v.to.3d](v.to.3d.md) | Performs transformation of 2D vector features to 3D. |
| [v.to.lines](v.to.lines.md) | Converts vector polygons or points to lines. |
| [v.to.points](v.to.points.md) | Creates points along input lines in new vector map with 2 layers. |
| [v.type](v.type.md) | Changes type of vector features. |
| [v.voronoi](v.voronoi.md) | Creates a Voronoi diagram constrained to the extents of the current region from an input vector map containing points or centroids. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [geometry] } -->
