---
name: v.boxplot.py
description: Draws a boxplot of values from a specified attribute column in a vector dataset, with an optional grouping based on categories in another column.
keywords: [ display, vector, plot, histogram, boxplot ]
---

# v.boxplot.py

Draws a boxplot of values from a specified attribute column in a vector dataset, with an optional grouping based on categories in another column.

=== "Command line"

    **v.boxplot.py**
    [**-honrg**]
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**group_by**=*name*]
    [**where**=*sql_query*]
    [**output**=*name*]
    [**plot_dimensions**=*string*]
    [**dpi**=*integer*]
    [**fontsize**=*integer*]
    [**order**=*string*]
    [**axis_limits**=*string*]
    [**bx_color**=*name*]
    [**bx_blcolor**=*name*]
    [**bx_width**=*float*]
    [**bx_lw**=*float*]
    [**median_lw**=*float*]
    [**median_color**=*name*]
    [**flier_marker**=*string*]
    [**flier_size**=*string*]
    [**flier_color**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.boxplot.py map=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.boxplot.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **group_by**=*None*,
        **where**=*None*,
        **output**=*None*,
        **plot_dimensions**=*None*,
        **dpi**=*100*,
        **fontsize**=*10*,
        **order**=*None*,
        **axis_limits**=*None*,
        **bx_color**=*"white"*,
        **bx_blcolor**=*"black"*,
        **bx_width**=*0.75*,
        **bx_lw**=*1*,
        **median_lw**=*1.1*,
        **median_color**=*"orange"*,
        **flier_marker**=*"o"*,
        **flier_size**=*"2"*,
        **flier_color**=*"black"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.boxplot.py", map="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_boxplot_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **group_by**=*None*,
        **where**=*None*,
        **output**=*None*,
        **plot_dimensions**=*None*,
        **dpi**=*100*,
        **fontsize**=*10*,
        **order**=*None*,
        **axis_limits**=*None*,
        **bx_color**=*"white"*,
        **bx_blcolor**=*"black"*,
        **bx_width**=*0.75*,
        **bx_lw**=*1*,
        **median_lw**=*1.1*,
        **median_color**=*"orange"*,
        **flier_marker**=*"o"*,
        **flier_size**=*"2"*,
        **flier_color**=*"black"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_boxplot_py(map="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column value to be plotted  
    **group_by**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column with categories to group the data by  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **plot_dimensions**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    **dpi**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;resolution of plot  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **fontsize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **order**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort boxplots based on their median values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *descending, ascending*  
    **axis_limits**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit value axis [min,max]  
    &nbsp;&nbsp;&nbsp;&nbsp;min and max value of y-axis, or x-axis if -h flag is set)  
    **bx_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **bx_blcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the borders of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the borderlines of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bx_width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot width  
    &nbsp;&nbsp;&nbsp;&nbsp;The width of the boxplots (0,1])  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.1-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.75*  
    **bx_lw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;boxplot linewidth  
    &nbsp;&nbsp;&nbsp;&nbsp;The boxplots border, whisker and cap line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **median_lw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;width of the boxplot median line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1*  
    **median_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxlot median line  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of median  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *orange*  
    **flier_marker**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *o*  
    **flier_size**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flier_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;horizontal boxplot(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw the boxplot horizontal  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with outliers  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;notch  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with notch  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotate labels  
    &nbsp;&nbsp;&nbsp;&nbsp;rotate x-axis labels  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column value to be plotted  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **group_by** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column with categories to group the data by  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **plot_dimensions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    **dpi** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;resolution of plot  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort boxplots based on their median values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *descending, ascending*  
    **axis_limits** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit value axis [min,max]  
    &nbsp;&nbsp;&nbsp;&nbsp;min and max value of y-axis, or x-axis if -h flag is set)  
    **bx_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **bx_blcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the borders of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the borderlines of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bx_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot width  
    &nbsp;&nbsp;&nbsp;&nbsp;The width of the boxplots (0,1])  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.1-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.75*  
    **bx_lw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;boxplot linewidth  
    &nbsp;&nbsp;&nbsp;&nbsp;The boxplots border, whisker and cap line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **median_lw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;width of the boxplot median line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1*  
    **median_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxlot median line  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of median  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *orange*  
    **flier_marker** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *o*  
    **flier_size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flier_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *o*, *n*, *r*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;horizontal boxplot(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the boxplot horizontal  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;notch  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with notch  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Rotate labels  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;rotate x-axis labels  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column value to be plotted  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **group_by** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column with categories to group the data by  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **plot_dimensions** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plot dimensions (width,height)  
    &nbsp;&nbsp;&nbsp;&nbsp;Dimensions (width,height) of the figure in inches  
    **dpi** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;DPI  
    &nbsp;&nbsp;&nbsp;&nbsp;resolution of plot  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **fontsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default font size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Sort boxplots based on their median values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *descending, ascending*  
    **axis_limits** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit value axis [min,max]  
    &nbsp;&nbsp;&nbsp;&nbsp;min and max value of y-axis, or x-axis if -h flag is set)  
    **bx_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **bx_blcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the borders of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the borderlines of the boxplots  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bx_width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boxplot width  
    &nbsp;&nbsp;&nbsp;&nbsp;The width of the boxplots (0,1])  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.1-1*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.75*  
    **bx_lw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;boxplot linewidth  
    &nbsp;&nbsp;&nbsp;&nbsp;The boxplots border, whisker and cap line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **median_lw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;width of the boxplot median line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1*  
    **median_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of the boxlot median line  
    &nbsp;&nbsp;&nbsp;&nbsp;Color of median  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *orange*  
    **flier_marker** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier marker  
    &nbsp;&nbsp;&nbsp;&nbsp;Set flier marker (see https://matplotlib.org/stable/api/markers_api.html for options)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *o*  
    **flier_size** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the flier size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flier_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the flier color  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *o*, *n*, *r*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;horizontal boxplot(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw the boxplot horizontal  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;notch  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw boxplot(s) with notch  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Rotate labels  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;rotate x-axis labels  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add grid lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *v.boxplot* module draws a boxplot of the values in a vector **map**
attribute **column**. Users can use the **where** option to select a
subset of the attribute table. Values in the column can also be grouped
according to the categories in another column (**group\_by**), creating
separate boxplots for each group.

Options to customize the appearance of the plot include rotating the
plot and x-axis labels, adding notches, removing outliers, and defining
the colors of various boxplot components. By default, the resulting plot
is displayed on the screen. However, users can save the plot to a file
by specifying the desired width, height, and resolution. The format of
the saved file is determined by the provided file extension. For
example, if `plot_output = outputfile.png`, the plot will be saved as a
PNG file.

## EXAMPLE

### Example 1

Use the vector layer `schools_wake` from the [NC sample
dataset](https://grass.osgeo.org/download/data/) to create boxplots of
the core capacity of schools in Wake County, North Carolina. Use the
**Where** clause to exclude all records with no data. Use the **-o**
flag to draw outliers.

```sh
v.boxplot -n -o map=schools_wake column=CORECAPACI where="CORECAPACI >0"
```

[![image-alt](v_boxplot_01.png)](v_boxplot_01.png)  
*Figure 1: Boxplot of core capacity of schools in Wake County.*

### Example 2

Use the vector layer `schools_wake` from the [NC sample
dataset](https://grass.osgeo.org/download/data/) to create boxplots of
the core capacity of the schools in Wake County, North Carolina, grouped
by city. Use the **Where** clause to exclude all records with missing
data. Use the **-o** flag to draw outliers.

```sh
v.boxplot -h -o map=schools_wake column=CORECAPACI where="CORECAPACI >0" group_by=ADDRCITY order=ascending
```

[![image-alt](v_boxplot_02.png)](v_boxplot_02.png)  
*Figure 2: Boxplot of core capacity of schools in Wake County, grouped
by city.*

## SEE ALSO

*[v.scatterplot](https://grass.osgeo.org/grass-stable/manuals/addons/v.scatterplot.html),
[d.vect.colhist](https://grass.osgeo.org/grass-stable/manuals/addons/d.vect.colhist.html),
[r.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.boxplot.html),
[r.series.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.series.boxplot.html),
[t.rast.boxplot](https://grass.osgeo.org/grass-stable/manuals/addons/t.rast.boxplot.html),
[r.scatterplot](https://grass.osgeo.org/grass-stable/manuals/addons/r.scatterplot.html)
[r3.scatterplot](https://grass.osgeo.org/grass-stable/manuals/addons/r3.scatterplot.html)*

## AUTHOR

[Paulo van Breugel](https://ecodiv.earth), [HAS green
academy](https://has.nl), [Innovative Biomonitoring research
group](https://www.has.nl/en/research/professorships/innovative-bio-monitoring-professorship/),
[Climate-robust Landscapes research
group](https://www.has.nl/en/research/professorships/climate-robust-landscapes-professorship/)

## SOURCE CODE

Available at: [v.boxplot source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.boxplot)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.boxplot))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
