---
name: v.centerpoint
description: Calculate center points
keywords: [ vector, geometry, center ]
---

# v.centerpoint

Calculate center points

=== "Command line"

    **v.centerpoint**
    [**-b**]
    **input**=*name*
    [**output**=*name*]
    [**type**=*string* [,*string*,...]]
    [**layer**=*string*]
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**pcenter**=*string* [,*string*,...]]
    [**lcenter**=*string* [,*string*,...]]
    [**acenter**=*string* [,*string*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.centerpoint input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.centerpoint***",
        **input**,
        **output**=*None*,
        **type**=*"point,line,area"*,
        **layer**=*"1"*,
        **cats**=*None*,
        **where**=*None*,
        **pcenter**=*"mean"*,
        **lcenter**=*"mid"*,
        **acenter**=*"mean"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.centerpoint", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_centerpoint*(**input**,
        **output**=*None*,
        **type**=*"point,line,area"*,
        **layer**=*"1"*,
        **cats**=*None*,
        **where**=*None*,
        **pcenter**=*"mean"*,
        **lcenter**=*"mid"*,
        **acenter**=*"mean"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_centerpoint(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **pcenter**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;point center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median, pmedian*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;**pmedian**: Point closest to geometric median  
    **lcenter**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;line center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mid, mean, median*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mid**: Line mid point  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance) using line segments  
    **acenter**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;area center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median, bmedian*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance) using area sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;**bmedian**: Geometric median (point of minimum distance) using boundary segments  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **pcenter** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;point center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median, pmedian*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;**pmedian**: Point closest to geometric median  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **lcenter** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;line center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mid, mean, median*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mid**: Line mid point  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance) using line segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **acenter** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;area center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median, bmedian*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance) using area sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;**bmedian**: Geometric median (point of minimum distance) using boundary segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **pcenter** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;point center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median, pmedian*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance)  
    &nbsp;&nbsp;&nbsp;&nbsp;**pmedian**: Point closest to geometric median  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **lcenter** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;line center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mid, mean, median*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mid**: Line mid point  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance) using line segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mid*  
    **acenter** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;area center  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mean, median, bmedian*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Center of gravity  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Geometric median (point of minimum distance) using area sizes  
    &nbsp;&nbsp;&nbsp;&nbsp;**bmedian**: Geometric median (point of minimum distance) using boundary segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.centerpoint* calculates center points for point clouds, lines and
areas. Center points can be centers of gravity (coordinates' mean) or
geometric medians (points of minimum distance, which is more robust in
case of outliers.

For points, center points are calculated considering all points. For
lines and areas, center points are calculated for each line or area
separately.

If no output vector is given, center points are printed to stdout in
ASCII point format:

```sh
<easting>|<northing>|<height>|<cat>
```

The category values are

- **1** - mean of points
- **2** - median of points
- **3** - point closest to median of points
- **4** - mid point of each line
- **5** - mean of each line
- **6** - median of each line
- **7** - mean of each area
- **8** - median of each area using area triangulation
- **9** - median of each area using boundaries

If an output vector is given, categories of the respective lines and
areas are transferred from the selected layer to layer 1. Layer 2 holds
the same category values as for output to stdout.

### Point centers

- **mean** - center of gravity, mean of all point coordinates
- **median** - geometric median, minimum distance to all points
- **pmedian** - point closest to the geometric median

### Line centers

- **mid** - the mid point of each line, lies exactly on the line
- **mean** - center of gravity, mean of all line segments, might not
    lie on the line
- **median** - geometric median, minimum distance to all line
    segments, might not lie on the line

### Area centers

- **mean** - center of gravity, calculated using area triangulation
- **median** - geometric median, minimum distance to area
    triangulation, might not lie inside the area
- **bmedian** - geometric median, minimum distance to boundary
    segments, might not lie inside the area

## EXAMPLE

Calculate center of gravity for the LiDAR point cloud 'elev\_lid\_bepts'
in the North Carolina sample dataset:

```sh
v.centerpoint input=elev_lid_bepts output=elev_lid_bepts_mean
```

```sh
v.centerpoint in=urbanarea out=urbanarea_median acenter=median
```

## SEE ALSO

*[v.centroids](https://grass.osgeo.org/grass-stable/manuals/v.centroids.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [v.centerpoint source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.centerpoint)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.centerpoint))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
