---
name: v.clip.py
description: Extracts features of input map which overlay features of clip map.
keywords: [ vector, clip, area ]
---

# v.clip.py

Extracts features of input map which overlay features of clip map.

=== "Command line"

    **v.clip.py**
    [**-dr**]
    **input**=*name*
    **clip**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.clip.py input=name clip=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.clip.py***",
        **input**,
        **clip**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.clip.py", input="name", clip="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_clip_py*(**input**,
        **clip**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_clip_py(input="name", clip="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to be clipped  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **clip**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of clip vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not dissolve clip map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Clip by region  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to be clipped  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **clip** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of clip vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not dissolve clip map  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clip by region  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to be clipped  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **clip** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of clip vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not dissolve clip map  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Clip by region  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.clip* module enables extracting those features of input vector map,
which overlay features of clip map, as well as their storing in a new
vector map.

In default, boundaries of clip map are dissolved before clipping.
Alternatively, flag **-d** can be ticked to retain the boundaries of
clip map. Flag **-r** facilitates clipping by current computational
region.

It is possible to clip vector maps consisting of points, lines, areas or
combinations of these. However, the current version does not fully
support clipping of mixed geometry containing points. In such a case,
the output map will only store clipped lines and/or areas.

## NOTES

*v.clip* is a front-end to *[v.overlay](v.overlay.md)*, as well as
*[v.select](v.select.md)*. Clipping of areas and/or lines can be
achieved using *[v.overlay](v.overlay.md)*. Clipping of points can be
performed with *[v.select](v.select.md)*.

## EXAMPLES

### Basic use

Clip railroads by counties Wake and Johnston in North Carolina (North
Carolina data set).

```sh
v.extract input=boundary_county where="NAME='WAKE' OR NAME='JOHNSTON'" output=county_WAKE_JOHNSTON
v.clip input=railroads clip=county_WAKE_JOHNSTON output=railroads_WAKE_JOHNSTON
```

![v.clip example](v_clip_poly.png)  
*Figure: v.clip example - basic use*

### Retain boundaries of clip map

```sh
v.clip -d input=railroads clip=county_WAKE_JOHNSTON output=railroads_WAKE_JOHNSTON
```

### Clip by current computational region

Clip hospitals by computational region adjusted to counties Wake and
Johnston in North Carolina (North Carolina data set). It is not
obligatory to enter name of clip map. In case it is stated, the clip map
will be omitted.

```sh
v.extract input=boundary_county where="NAME='WAKE' OR NAME='JOHNSTON'" output=county_WAKE_JOHNSTON
v.clip -r input=hospitals output=hospitals_clip
```

![v.clip example](v_clip_region.png)  
*Figure: v.clip example - clip by computational region*

## SEE ALSO

*[v.overlay](v.overlay.md), [v.select](v.select.md),
[v.dissolve](v.dissolve.md), [v.in.region](v.in.region.md)*

## AUTHOR

Zofie Cimburova, [GeoForAll
Lab](http://geomatics.fsv.cvut.cz/research/geoforall/), Czech Technical
University in Prague, Czech Republic

## SOURCE CODE

Available at: [v.clip source code](https://github.com/OSGeo/grass/tree/main/scripts/v.clip)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.clip))  
Latest change: Wednesday May 21 14:24:15 2025 in commit [86e588a](https://github.com/OSGeo/grass/commit/86e588ac7ef1d6db04e5f405c5ab080bb08bc37b)
