---
name: v.colors2.py
description: Sets color rules for features in a vector map using a numeric attribute column.
keywords: [ vector, color table ]
---

# v.colors2.py

Sets color rules for features in a vector map using a numeric attribute column.

=== "Command line"

    **v.colors2.py**
    [**-sn**]
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**rgb_column**=*name*]
    [**range**=*min,max*]
    [**color**=*string*]
    [**raster**=*name*]
    [**rules**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.colors2.py map=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.colors2.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **rgb_column**=*"GRASSRGB"*,
        **range**=*None*,
        **color**=*None*,
        **raster**=*None*,
        **rules**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.colors2.py", map="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_colors2_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **rgb_column**=*"GRASSRGB"*,
        **range**=*None*,
        **color**=*None*,
        **raster**=*None*,
        **rules**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_colors2_py(map="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column containing numeric data  
    **rgb_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color column to populate with RGB values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GRASSRGB*  
    **range**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manually set range (min,max)  
    **color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, gdd, grey, grey1.0, grey255, grey.eq, grey.log, gyr, ndvi, population, precipitation, rainbow, ramp, random, ryb, ryg, sepia, slope, srtm, terrain, wave*  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map from which to copy color table  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing rules  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Save placeholder raster map for use with d.legend  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column containing numeric data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color column to populate with RGB values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GRASSRGB*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manually set range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, gdd, grey, grey1.0, grey255, grey.eq, grey.log, gyr, ndvi, population, precipitation, rainbow, ramp, random, ryb, ryg, sepia, slope, srtm, terrain, wave*  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Save placeholder raster map for use with d.legend  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column containing numeric data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color column to populate with RGB values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GRASSRGB*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manually set range (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, gdd, grey, grey1.0, grey255, grey.eq, grey.log, gyr, ndvi, population, precipitation, rainbow, ramp, random, ryb, ryg, sepia, slope, srtm, terrain, wave*  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rules** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file containing rules  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Save placeholder raster map for use with d.legend  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.colors* is much like *r.colors*, but may be used for vector maps. You
give it a vector map and numeric data column, together with color rules
like you would do for a raster. It creates a new column in the database
with R:G:B values suitable for use with '`d.vect -a`'.

How it works: it creates a dummy raster map with the same data range as
the vector's column then runs *r.colors* for that temporary map. It then
uses *r.what.colors* for each value found by *v.db.select* and uploads
it a new column in the vector map's attribute database.

It is planned that this script will be replaced with a C display module
which renders thematic vector maps directly instead requiring the
overhead of saving the colors into the DB.

If the target column name given by the **rgb\_column** option does not
exist, it will be created. The default name is "`GRASSRGB`".

## EXAMPLES

Create a random sample point map, query raster map values for those
points, and colorize output.

```sh
# Spearfish dataset
g.region -d
v.random out=rand5k_elev n=5000
v.db.addtable map=rand5k_elev column='elevation double precision'
v.what.rast vector=rand5k_elev raster=elevation.10m column=elevation
v.colors map=rand5k_elev column=elevation color=bcyr

# display colorized points map
d.mon x0
d.vect -a rand5k_elev
```

Colorizing the roads map in Spearfish:

```sh
g.copy vector=roads,myroads
echo "1 red
2 yellow
3 orange
4 black
5 grey" > colors.txt

v.colors myroads column=cat rules=colors.txt

# display colorized roads map
d.mon x0
d.vect -a myroads
```

Colorizing a TIN (polygons) generated by *v.delaunay*:

```sh
# new columns for x,y,z of centroids
v.db.addtable map=tin \
   columns="east double precision, north double precision, height double precision, GRASSRGB varchar(11)"

# transfer geometry for colorizing (we need the centroid height)
v.to.db tin option=coor columns="east,north,height"
v.db.select tin

v.colors tin column=height rgb_column=GRASSRGB color=rainbow

# display colorized triangles
d.mon x0
d.vect -a tin
```

## SEE ALSO

*[d.vect](https://grass.osgeo.org/grass-stable/manuals/d.vect.html),
[r.colors](https://grass.osgeo.org/grass-stable/manuals/r.colors.html),
[r.colors.stddev](https://grass.osgeo.org/grass-stable/manuals/r.colors.stddev.html),
[r.what.color](https://grass.osgeo.org/grass-stable/manuals/r.what.color.html),
[v.db.addcolumn](https://grass.osgeo.org/grass-stable/manuals/v.db.addcolumn),
[v.db.select](https://grass.osgeo.org/grass-stable/manuals/v.db.select.html),
[db.execute](https://grass.osgeo.org/grass-stable/manuals/db.execute.html)*

## AUTHOR

Hamish Bowman  
*Dunedin, New Zealand*

## SOURCE CODE

Available at: [v.colors2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.colors2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.colors2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
