---
name: v.convert
description: Imports older versions of GRASS vector maps.
keywords: [ vector, import, conversion ]
---

# v.convert

Imports older versions of GRASS vector maps.

=== "Command line"

    **v.convert**
    **input**=*name*
    [**output**=*name*]
    [**endian**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.convert input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.convert***",
        **input**,
        **output**=*None*,
        **endian**=*"big"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.convert", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_convert*(**input**,
        **output**=*None*,
        **endian**=*"big"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_convert(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **endian**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Endian of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *big*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **endian** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Endian of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *big*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **endian** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Endian of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *big*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.convert* converts GRASS 5.0/5.3/5.4 vectors into 5.7/6.x vectors.

## NOTES

Vector maps from 5.0/5.3/5.4 and 5.7/6.x do not interfere. They are
stored in different directories, so you can use the same names. Old
vector maps can be listed with *g.list oldvect*.

If you need to convert back from 5.7/6.x into the 5.0/5.3/5.4 vector
format, use *v.out.ogr* (to SHAPE format) and then *v.in.shape* in the
old GRASS program. Alternatively use "*v.out.ascii -o*" and
*v.in.ascii*.

As this GRASS version uses SQL for attribute management, there are some
[SQL restrictings concerning the file names](sql.md).

Missing centroids can be added with *v.category*.

## EXAMPLE

```sh
v.convert in=vectormap_from_50 out=vectormap_60
```

## SEE ALSO

[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html),
[v.category](https://grass.osgeo.org/grass-stable/manuals/v.category.html),
[v.convert.all](https://grass.osgeo.org/grass-stable/manuals/v.convert.all.html),
[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html),
[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html),
[v.out.ogr](https://grass.osgeo.org/grass-stable/manuals/v.out.ogr.html)

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [v.convert source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.convert)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.convert))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
