---
name: v.db.addcolumn.py
description: Adds one or more columns to the attribute table connected to a given vector map.
keywords: [ vector, attribute table, database ]
---

# v.db.addcolumn.py

Adds one or more columns to the attribute table connected to a given vector map.

=== "Command line"

    **v.db.addcolumn.py**
    **map**=*name*
    [**layer**=*string*]
    **columns**=*name type* [,*name type*,...]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.addcolumn.py map=name columns=name type
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.db.addcolumn.py***",
        **map**,
        **layer**=*"1"*,
        **columns**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.db.addcolumn.py", map="name", columns="name type")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_addcolumn_py*(**map**,
        **layer**=*"1"*,
        **columns**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_addcolumn_py(map="name", columns="name type")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to add column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **columns**=*name type* [,*name type*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and type of the new column(s) ('name type [,name type, ...]')  
    &nbsp;&nbsp;&nbsp;&nbsp;Types depend on database backend, but all support VARCHAR(), INT, DOUBLE PRECISION and DATE. Example: 'label varchar(250), value integer'  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to add column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and type of the new column(s) ('name type [,name type, ...]')  
    &nbsp;&nbsp;&nbsp;&nbsp;Types depend on database backend, but all support VARCHAR(), INT, DOUBLE PRECISION and DATE. Example: 'label varchar(250), value integer'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name type*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to add column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and type of the new column(s) ('name type [,name type, ...]')  
    &nbsp;&nbsp;&nbsp;&nbsp;Types depend on database backend, but all support VARCHAR(), INT, DOUBLE PRECISION and DATE. Example: 'label varchar(250), value integer'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name type*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.addcolumn* adds one or more column(s) to the attribute table
connected to a given vector map. It automatically checks the connection
for the specified layer.

## NOTES

*v.db.addcolumn* is a front-end to *db.execute* to allow easier usage.
The supported types of columns depend on the database backend. However,
all backends should support VARCHAR, INT, DOUBLE PRECISION and DATE.

The existing database connection(s) can be verified with *v.db.connect*.

## EXAMPLES

Adding a single column:  

```sh
g.copy vect=roadsmajor,myroads
v.db.addcolumn myroads columns="slope double precision"
v.info -c myroads
```

Adding two columns:  

```sh
g.copy vect=roadsmajor,myroads
v.db.addcolumn myroads columns="slope double precision,myname varchar(15)"
v.info -c myroads
```

## SEE ALSO

*[db.connect](db.connect.md), [db.execute](db.execute.md),
[v.db.addtable](v.db.addtable.md), [v.db.connect](v.db.connect.md),
[v.db.dropcolumn](v.db.dropcolumn.md),
[v.db.droptable](v.db.droptable.md), [v.db.select](v.db.select.md),
[v.db.update](v.db.update.md)*

*[GRASS SQL interface](sql.md)*

## AUTHOR

Moritz Lennert (<mlennert@club.worldonline.be>)

## SOURCE CODE

Available at: [v.db.addcolumn source code](https://github.com/OSGeo/grass/tree/main/scripts/v.db.addcolumn)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.db.addcolumn))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
