---
name: v.greedycolors
description: Create greedy colors for vector areas.
keywords: [ vector, color table ]
---

# v.greedycolors

Create greedy colors for vector areas.

=== "Command line"

    **v.greedycolors**
    **map**=*name*
    [**layer**=*string*]
    [**column**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.greedycolors map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.greedycolors***",
        **map**,
        **layer**=*"1"*,
        **column**=*"greedyclr"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.greedycolors", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_greedycolors*(**map**,
        **layer**=*"1"*,
        **column**=*"greedyclr"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_greedycolors(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *greedyclr*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *greedyclr*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *greedyclr*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.greedycolors* assigns numbers to areas such that no two adjacent
areas have the same number. At the same time, it tries to use as few
numbers as possible. The numbers are stored in the attribute table, by
default in the column "greedyclr" which is created if not existing.
These numbers can then be used to assign RGB colors in a new column to
be used with e.g. *d.vect* .

*v.greedycolors* works best if areas have unique categories. If multiple
areas have the same category, the corresponding network of neighboring
areas can become fairly complex, resulting in a larger number of greedy
colors. If the purpose is to assign different colors to neighboring
areas, irrespective of their category values, unique category values
need to be assigned first, e.g. to a new layer with
*[v.category](v.category)*.

There is always at least one optimal solution for greedy colors, using
as few colors as possible. However, it is usually computationally
intensive and not practical to search for an optimal solution. Therefore
a good solution is aproximated by ordering the areas first, before
assigning greedy colors. Here, the areas with the least neighbors are
processed first.

## EXAMPLE

Assigning greedy colors to county boundaries in the North Carolina
sample dataset:

Make a copy of the data:

```sh
g.copy vect=boundary_county,my_boundary_county
```

Greedy colors

```sh
v.greedycolors map=my_boundary_county
```

Check number and frequency of greedy colors

```sh
db.select sql="select greedyclr,count(greedyclr) from my_boundary_county group by greedyclr"
```

gives

```text
greedyclr|count(greedyclr)
1|262
2|351
3|302
4|11
```

four different colors were needed such that no two adjacent areas have
the same color

Assign RGB colors:

```sh
v.db.addcolumn map=my_boundary_county column="GRASSRGB varchar(11)"

v.db.update map=my_boundary_county column=GRASSRGB value="127:201:127" where="greedyclr = 1"
v.db.update map=my_boundary_county column=GRASSRGB value="190:174:212" where="greedyclr = 2"
v.db.update map=my_boundary_county column=GRASSRGB value="253:192:134" where="greedyclr = 3"
v.db.update map=my_boundary_county column=GRASSRGB value="255:255:153" where="greedyclr = 4"
```

## SEE ALSO

*[v.colors](v.colors.md), [v.category](v.category.md)*

## AUTHOR

Markus Metz, mundialis, Germany

## SOURCE CODE

Available at: [v.greedycolors source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.greedycolors)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.greedycolors))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
