---
name: v.gsflow.reaches.py
description: Build stream "reaches" that link PRMS segments to MODFLOW cells
keywords: [ vector, stream network, hydrology, GSFLOW ]
---

# v.gsflow.reaches.py

Build stream "reaches" that link PRMS segments to MODFLOW cells

=== "Command line"

    **v.gsflow.reaches.py**
    **segment_input**=*name*
    **grid_input**=*name*
    **elevation**=*name*
    **output**=*name*
    [**s_min**=*float*]
    [**h_stream**=*float*]
    [**upstream_easting_column_seg**=*string*]
    [**upstream_northing_column_seg**=*string*]
    [**downstream_easting_column_seg**=*string*]
    [**downstream_northing_column_seg**=*string*]
    [**tostream_cat_column_seg**=*string*]
    [**strthick**=*float*]
    [**strhc1**=*float*]
    [**thts**=*float*]
    [**thti**=*float*]
    [**eps**=*float*]
    [**uhc**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.gsflow.reaches.py segment_input=name grid_input=name elevation=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.gsflow.reaches.py***",
        **segment_input**,
        **grid_input**,
        **elevation**,
        **output**,
        **s_min**=*0.0001*,
        **h_stream**=*1*,
        **upstream_easting_column_seg**=*"x1"*,
        **upstream_northing_column_seg**=*"y1"*,
        **downstream_easting_column_seg**=*"x2"*,
        **downstream_northing_column_seg**=*"y2"*,
        **tostream_cat_column_seg**=*"tostream"*,
        **strthick**=*1*,
        **strhc1**=*5*,
        **thts**=*0.35*,
        **thti**=*0.3*,
        **eps**=*3.5*,
        **uhc**=*0.3*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.gsflow.reaches.py", segment_input="name", grid_input="name", elevation="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_gsflow_reaches_py*(**segment_input**,
        **grid_input**,
        **elevation**,
        **output**,
        **s_min**=*0.0001*,
        **h_stream**=*1*,
        **upstream_easting_column_seg**=*"x1"*,
        **upstream_northing_column_seg**=*"y1"*,
        **downstream_easting_column_seg**=*"x2"*,
        **downstream_northing_column_seg**=*"y2"*,
        **tostream_cat_column_seg**=*"tostream"*,
        **strthick**=*1*,
        **strhc1**=*5*,
        **thts**=*0.35*,
        **thti**=*0.3*,
        **eps**=*3.5*,
        **uhc**=*0.3*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_gsflow_reaches_py(segment_input="name", grid_input="name", elevation="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **segment_input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;PRMS stream segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **grid_input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;DEM for slope along reaches  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches for GSFLOW  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **s_min**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum reach slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0001*  
    **h_stream**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream channel depth (bank height) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **upstream_easting_column_seg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream easting (or x or lon) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *x1*  
    **upstream_northing_column_seg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream northing (or y or lat) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *y1*  
    **downstream_easting_column_seg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream easting (or x or lon) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *x2*  
    **downstream_northing_column_seg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream northing (or y or lat) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *y2*  
    **tostream_cat_column_seg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Adjacent downstream segment cat (0 = offmap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tostream*  
    **strthick**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed sediment thickness [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **strhc1**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed hydraulic conductivity [m/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **thts**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;theta_sat: Streambed saturated water content (i.e. porosity) [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.35*  
    **thti**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed initial water content [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **eps**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Epsilon: streambed Brooks-Corey exponent [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.5*  
    **uhc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed unsaturated zone saturated hydraulic conductivity [m/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **segment_input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;PRMS stream segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **grid_input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEM for slope along reaches  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches for GSFLOW  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **s_min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum reach slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0001*  
    **h_stream** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream channel depth (bank height) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **upstream_easting_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream easting (or x or lon) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *x1*  
    **upstream_northing_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream northing (or y or lat) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *y1*  
    **downstream_easting_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream easting (or x or lon) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *x2*  
    **downstream_northing_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream northing (or y or lat) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *y2*  
    **tostream_cat_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Adjacent downstream segment cat (0 = offmap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tostream*  
    **strthick** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed sediment thickness [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **strhc1** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed hydraulic conductivity [m/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **thts** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;theta_sat: Streambed saturated water content (i.e. porosity) [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.35*  
    **thti** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed initial water content [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **eps** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Epsilon: streambed Brooks-Corey exponent [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.5*  
    **uhc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed unsaturated zone saturated hydraulic conductivity [m/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **segment_input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;PRMS stream segments  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **grid_input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEM for slope along reaches  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches for GSFLOW  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **s_min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum reach slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0001*  
    **h_stream** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream channel depth (bank height) [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **upstream_easting_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream easting (or x or lon) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *x1*  
    **upstream_northing_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream northing (or y or lat) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *y1*  
    **downstream_easting_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream easting (or x or lon) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *x2*  
    **downstream_northing_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream northing (or y or lat) column name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *y2*  
    **tostream_cat_column_seg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Adjacent downstream segment cat (0 = offmap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *tostream*  
    **strthick** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed sediment thickness [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **strhc1** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed hydraulic conductivity [m/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **thts** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;theta_sat: Streambed saturated water content (i.e. porosity) [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.35*  
    **thti** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed initial water content [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **eps** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Epsilon: streambed Brooks-Corey exponent [unitless]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.5*  
    **uhc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streambed unsaturated zone saturated hydraulic conductivity [m/day]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.gsflow.reaches* produces channel "reaches", which are the
intersection between PRMS stream segments and MODFLOW grid cells, for
the USGS combined groundwater and surface-water model GSFLOW.

## REFERENCES

Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
vegetation in the hydrological response of tropical glaciated watersheds
to climate change, in AGU Fall Meeting Abstracts, H13L–1590, San
Francisco, CA.

## SEE ALSO

[v.gsflow.export](v.gsflow.export),
[v.gsflow.gravres](v.gsflow.gravres), [v.gsflow.grid](v.gsflow.grid),
[v.gsflow.hruparams](v.gsflow.hruparams),
[v.gsflow.segments](v.gsflow.segments),
[v.gsflow.mapdata](v.gsflow.mapdata),
[v.stream.inbasin](v.stream.inbasin),
[v.stream.network](v.stream.network)

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.gsflow.reaches source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.gsflow.reaches)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.gsflow.reaches))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
