---
name: v.in.csv.py
description: Import a CSV file using pyproj for CRS transformation
keywords: [ vector, import, projection, transformation, point, ASCII, CSV ]
---

# v.in.csv.py

Import a CSV file using pyproj for CRS transformation

=== "Command line"

    **v.in.csv.py**
    **input**=*name*
    **output**=*name*
    **separator**=*character*
    **latitude**=*string*
    **longitude**=*string*
    **crs**=*string*
    [**limit**=*integer*]
    [**int_columns**=*string* [,*string*,...]]
    [**real_columns**=*string* [,*string*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.csv.py input=name output=name separator=comma latitude=string longitude=string crs=EPSG:4326
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.csv.py***",
        **input**,
        **output**,
        **separator**=*"comma"*,
        **latitude**,
        **longitude**,
        **crs**=*"EPSG:4326"*,
        **limit**=*None*,
        **int_columns**=*None*,
        **real_columns**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.csv.py", input="name", output="name", separator="comma", latitude="string", longitude="string", crs="EPSG:4326")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_csv_py*(**input**,
        **output**,
        **separator**=*"comma"*,
        **latitude**,
        **longitude**,
        **crs**=*"EPSG:4326"*,
        **limit**=*None*,
        **int_columns**=*None*,
        **real_columns**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_csv_py(input="name", output="name", separator="comma", latitude="string", longitude="string", crs="EPSG:4326")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **separator**=*character* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **latitude**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as latitude  
    **longitude**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as longitude  
    **crs**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate reference system (CRS) of the coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code (e.g. 4326 or EPSG:4326), WKT string, and PROJ string are recognized  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *EPSG:4326*  
    **limit**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit number of lines processed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **int_columns**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns which are integers  
    **real_columns**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns which are double floating point numbers (floats)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **separator** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **latitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as latitude  
    **longitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as longitude  
    **crs** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate reference system (CRS) of the coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code (e.g. 4326 or EPSG:4326), WKT string, and PROJ string are recognized  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *EPSG:4326*  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit number of lines processed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **int_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns which are integers  
    **real_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns which are double floating point numbers (floats)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **separator** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **latitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as latitude  
    **longitude** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column used as longitude  
    **crs** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinate reference system (CRS) of the coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG code (e.g. 4326 or EPSG:4326), WKT string, and PROJ string are recognized  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *EPSG:4326*  
    **limit** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit number of lines processed  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    **int_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns which are integers  
    **real_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of columns which are double floating point numbers (floats)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.csv* imports rows from a CSV (Comma Separated Value) file into a
vector map as points with attributes. The separator for CSV is comma
(`,`) by default, but it can be set to any single character such as
semicolon (`;`), pipe (`|`), or tabulator.

## NOTES

The module requires the "pyproj" Python package to work.

## EXAMPLES

The following imports CSV file called `latest_sites.csv` in the current
directory into the current mapset as point vector map named
`sampling_sites` using the default coordinate transformation from WGS84.
Latitude and longitude are in columns `Site_Lat` and `Site_Long`.

```sh
v.in.csv input=latest_sites.csv output=sampling_sites latitude=Site_Lat longitude=Site_Long
```

## SEE ALSO

- *[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html)*
    for the underlying module with finer control (but not coordinate
    transformation),
- *[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html)*
    for an alternative CSV import using GDAL/OGR.

## AUTHOR

Vaclav Petras, [NCSU Center for Geospatial
Analytics](https://cnr.ncsu.edu/geospatial/)

## SOURCE CODE

Available at: [v.in.csv source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.csv)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.csv))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
