---
name: v.in.geonames.py
description: Imports geonames.org country files into a vector points map.
keywords: [ vector, import, gazetteer ]
---

# v.in.geonames.py

Imports geonames.org country files into a vector points map.

=== "Command line"

    **v.in.geonames.py**
    **input**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.geonames.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.geonames.py***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.geonames.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_geonames_py*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_geonames_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of uncompressed geonames file (with .txt extension)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of uncompressed geonames file (with .txt extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of uncompressed geonames file (with .txt extension)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.geonames* imports Geonames.org country files (Gazetteer data) into
a GRASS vector points map. The country files can be downloaded from the
[GeoNames Data Dump Server](https://download.geonames.org/export/dump/).
Only original files can be processed (unzip compressed file first).
These Geonames files are encoded in UTF-8 which is maintained in the
GRASS database.

## NOTES

*v.in.geonames* calls *[v.in.ascii](v.in.ascii.md)* to import data into
GRASS.

The current DB connection is used to write the database table (see
*[db.connect](db.connect.md)*). If importing into a [DBF
database](grass-dbf.md), the original column names longer that 10
characters are shortened to 10 characters to meet the DBF column name
restrictions. If this is a problem consider choosing another database
driver with *[db.connect](db.connect.md)* (eg. to [SQLite
driver](grass-sqlite.md)).

The main 'geoname' table has the following fields

```sh
geonameid         : integer id of record in geonames database
name              : name of geographical point (utf8) varchar(200)
asciiname         : name of geographical point in plain ascii characters, varchar(200)
alternatenames    : alternatenames, comma separated varchar(4000)
latitude          : latitude in decimal degrees (wgs84)
longitude         : longitude in decimal degrees (wgs84)
feature class     : see https://www.geonames.org/export/codes.html, char(1)
feature code      : see https://www.geonames.org/export/codes.html, varchar(10)
country code      : ISO-3166 2-letter country code, 2 characters
cc2               : alternate country codes, comma separated, ISO-3166 2-letter country code, 60 characters
admin1 code       : fipscode (subject to change to iso code), isocode for the us and ch, see file admin1Codes.txt for display names of this code; varchar(20)
admin2 code       : code for the second administrative division, a county in the US, see file admin2Codes.txt; varchar(80)
admin3 code       : code for third level administrative division, varchar(20)
admin4 code       : code for fourth level administrative division, varchar(20)
population        : integer
elevation         : in meters, integer
gtopo30           : average elevation of 30'x30' (ca 900mx900m) area in meters, integer
timezone          : the timezone id (see file https://download.geonames.org/export/dump/timeZones.txt)
modification date : date of last modification in yyyy-MM-dd format
```

## EXAMPLE

Download and import geonames for Czech Republic.

```sh
wget https://download.geonames.org/export/dump/CZ.zip
unzip CZ.zip

v.in.geonames input=CZ.txt output=geonames_cz
```

## REFERENCES

- [GeoNames Web site](https://www.geonames.org)
- [GeoNames Data Dump
  Server](https://download.geonames.org/export/dump/)

## SEE ALSO

*[db.connect](db.connect.md), [v.in.ascii](v.in.ascii.md),
[v.select](v.select.md)*

## AUTHOR

[Markus Neteler](https://grassbook.org/)

## SOURCE CODE

Available at: [v.in.geonames source code](https://github.com/OSGeo/grass/tree/main/scripts/v.in.geonames)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.in.geonames))  
Latest change: Thursday May 22 03:42:15 2025 in commit [370bcb0](https://github.com/OSGeo/grass/commit/370bcb0490b421ac90b2dbe5766af9512cb08f92)
