---
name: v.in.ogc.features.py
description: Downloads and imports data from OGC API Features server.
keywords: [ vector, import, ogc, features ]
---

# v.in.ogc.features.py

Downloads and imports data from OGC API Features server.

=== "Command line"

    **v.in.ogc.features.py**
    [**-l**]
    **url**=*string*
    [**layer**=*string*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.ogc.features.py url=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.ogc.features.py***",
        **url**,
        **layer**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.ogc.features.py", url="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_ogc_features_py*(**url**,
        **layer**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_ogc_features_py(url="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of OGC API Features server  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer to request from server  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Get layers from the server  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of OGC API Features server  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer to request from server  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get layers from the server  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of OGC API Features server  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer to request from server  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get layers from the server  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.ogc.features* in able to import data from an OGC API Features
Service.

## EXAMPLES

```sh
v.in.ogc.features -l url=https://demo.pygeoapi.io/stable

v.in.ogc.features url=https://demo.pygeoapi.io/stable layers=lakes output=large_lakes
```

## SEE ALSO

More info about [OGC API Features](https://ogcapi.ogc.org/features/).
*[v.in.ogc.coverages](v.in.ogc.coverages.md), [r.in.ogc](r.in.ogc.md)*

## AUTHOR

Luca Delucchi, Fondazione Edmund Mach, during Joint OGC OSGeo ASF Code
Sprint 2021.

## SOURCE CODE

Available at: [v.in.ogc.features source code](https://github.com/OSGeo/grass-addons/tree/grass8/vector/v.in.ogc/v.in.ogc.features)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/vector/v.in.ogc/v.in.ogc.features))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
