---
name: v.in.redlist.py
description: importing of IUCN Red List Spatial Data
keywords: [ vector, geometry ]
---

# v.in.redlist.py

importing of IUCN Red List Spatial Data

=== "Command line"

    **v.in.redlist.py**
    [**-ls**]
    **input**=*name*
    [**output**=*name*]
    [**species_name**=*string*]
    [**dir**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.redlist.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.redlist.py***",
        **input**,
        **output**=*None*,
        **species_name**=*None*,
        **dir**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.redlist.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_redlist_py*(**input**,
        **output**=*None*,
        **species_name**=*None*,
        **dir**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_redlist_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;name of the IUCN Red List Spatial Data shapefile  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of the imported IUCN Red List Spatial Data  
    **species_name**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of species which should be imported  
    **dir**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the species list will be found  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;list species in IUCN Red List Spatial Data  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;save species list to a text file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of the IUCN Red List Spatial Data shapefile  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of the imported IUCN Red List Spatial Data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **species_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of species which should be imported  
    **dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the species list will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;list species in IUCN Red List Spatial Data  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;save species list to a text file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of the IUCN Red List Spatial Data shapefile  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of the imported IUCN Red List Spatial Data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **species_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;name of species which should be imported  
    **dir** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Directory where the species list will be found  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;list species in IUCN Red List Spatial Data  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;save species list to a text file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.redlist* imports [IUCN](https://www.iucn.org) [Red
List](https://www.iucnredlist.org/) [Spatial
Data](https://www.iucnredlist.org/resources/list/spatial-data). This
data is by definition in WGS84 geographic coordinates.

By the *-l* flag species in column 'binomial' of the attribute table are
listed. The species in column 'binomial' can be exported to a text file
by the *-s* flag.

One of the species mentioned by *-l* or *-s* flag has to be specified
for importing.

## EXAMPLE

```sh
  # list species in column 'binomial' of the attribute table by -l flag
  v.in.redlist -l input=GYMNOPHIONA.shp

  # export species in column 'binomial' of the attribute table into a text file by -s flag
  v.in.redlist -s input=GYMNOPHIONA.shp dir=C:\data\iucn\GYMNOPHIONA

  # import spatial data for a user defined species
  v.in.redlist input=GYMNOPHIONA.shp /
  output=Scolecomorphus_vittatus species_name=Scolecomorphus vittatus
 
```

## SEE ALSO

*[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html)*

## AUTHOR

Helmut Kudrnovsky

## SOURCE CODE

Available at: [v.in.redlist source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.redlist)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.redlist))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
