---
name: v.median.py
description: Return the barycenter of a cloud of point.
keywords: [ vector ]
---

# v.median.py

Return the barycenter of a cloud of point.

=== "Command line"

    **v.median.py**
    **input**=*name*
    [**output**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.median.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.median.py***",
        **input**,
        **output**=*"-"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.median.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_median_py*(**input**,
        **output**=*"-"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_median_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to pack up  
    **output**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file ('-' for standard output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to pack up  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file ('-' for standard output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to pack up  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file ('-' for standard output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.median* create the median point of a cloud of point.

## EXAMPLE

Return the median point to the standard output

```sh
v.median input=random_point

12.588035|42.664944
```

Create a vector with the median point

```sh
v.median input=random_point output=median_random_point

```

## AUTHORS

Luca Delucchi, Fondazione E. Mach (Italy)

## SOURCE CODE

Available at: [v.median source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.median)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.median))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
