---
name: v.net.salesman.opt
description: Creates a cycle connecting given nodes (Traveling salesman problem). Note that TSP is NP-hard, heuristic algorithm is used by this module and created cycle may be suboptimal
keywords: [ vector, network, salesman ]
---

# v.net.salesman.opt

Creates a cycle connecting given nodes (Traveling salesman problem).

Note that TSP is NP-hard, heuristic algorithm is used by this module and created cycle may be suboptimal

=== "Command line"

    **v.net.salesman.opt**
    [**-g**]
    **input**=*name*
    **output**=*name*
    [**type**=*string* [,*string*,...]]
    [**alayer**=*string*]
    [**nlayer**=*string*]
    [**afcolumn**=*string*]
    [**abcolumn**=*string*]
    [**sequence**=*name*]
    **ccats**=*range*
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.net.salesman.opt input=name output=name ccats=range
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.net.salesman.opt***",
        **input**,
        **output**,
        **type**=*"line,boundary"*,
        **alayer**=*"1"*,
        **nlayer**=*"2"*,
        **afcolumn**=*None*,
        **abcolumn**=*None*,
        **sequence**=*None*,
        **ccats**,
        **method**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.net.salesman.opt", input="name", output="name", ccats="range")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_net_salesman_opt*(**input**,
        **output**,
        **type**=*"line,boundary"*,
        **alayer**=*"1"*,
        **nlayer**=*"2"*,
        **afcolumn**=*None*,
        **abcolumn**=*None*,
        **sequence**=*None*,
        **ccats**,
        **method**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_net_salesman_opt(input="name", output="name", ccats="range")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line,boundary*  
    **alayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **nlayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Node layer (used for cities)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **afcolumn**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc forward/both direction(s) cost column (number)  
    **abcolumn**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;EXPERIMENTAL: Arc backward direction cost column (number)  
    **sequence**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file holding node sequence ("-" for stdout)  
    **ccats**=*range* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Categories of points ('cities') on nodes (layer is specified by nlayer)  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimization method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bs, ga*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bs**: bootstrapping  
    &nbsp;&nbsp;&nbsp;&nbsp;**ga**: genetic algorithm  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use geodesic calculation for longitude-latitude locations  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line,boundary*  
    **alayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **nlayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Node layer (used for cities)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **afcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc forward/both direction(s) cost column (number)  
    **abcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EXPERIMENTAL: Arc backward direction cost column (number)  
    **sequence** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file holding node sequence ("-" for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **ccats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Categories of points ('cities') on nodes (layer is specified by nlayer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimization method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bs, ga*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bs**: bootstrapping  
    &nbsp;&nbsp;&nbsp;&nbsp;**ga**: genetic algorithm  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use geodesic calculation for longitude-latitude locations  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *line,boundary*  
    **alayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **nlayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Node layer (used for cities)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **afcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Arc forward/both direction(s) cost column (number)  
    **abcolumn** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EXPERIMENTAL: Arc backward direction cost column (number)  
    **sequence** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file holding node sequence ("-" for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **ccats** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Categories of points ('cities') on nodes (layer is specified by nlayer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimization method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bs, ga*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bs**: bootstrapping  
    &nbsp;&nbsp;&nbsp;&nbsp;**ga**: genetic algorithm  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use geodesic calculation for longitude-latitude locations  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.net.salesman.opt* estimates the optimal route to visit nodes on a
vector network and optionally tries to improve the result.

Costs may be either line lengths, or attributes saved in a database
table. These attribute values are taken as costs of whole segments, not
as costs to traverse a length unit (e.g. meter) of the segment. For
example, if the speed limit is 100 km / h, the cost to traverse a 10 km
long road segment must be calculated as length / speed = 10 km / (100
km/h) = 0.1 h. Supported are cost assignments for arcs, and also
different costs for both directions of a vector line. For areas, costs
will be calculated along boundary lines.

The input vector needs to be prepared with *v.net operation=connect* in
order to connect points representing center nodes to the network.

Points specified by category must be exactly on network nodes, and the
input vector map needs to be prepared with *v.net operation=connect*.

### Optimization

For less than 10 nodes, the initial result is usually very close to the
shortest possible tour and further optimization will have no effect.

*v.net.salesman.opt* uses the same heuristics like *v.net.salesman.opt*
to find a good tour which is not necessarily the optimal tour. The tour
can be optimized with two methods: bootstrapping and genetic algorithm
(GA). The bootstrapping method removes a subtour from the tour and
reinserts the nodes resulting in a shorter tour. This is applied on
intermediate tours and the final tour.

The genetic algorithm first creates several initial tours. From these
tours nearly identical toursare eliminated. The remaining tours are
recombined to create new, better tours. All tours are now mutated. The
sequence of Selection, Recombination, Mutation is repeated until there
is no better solution. Finally, the best tour is optimized with
bootstrapping.

## NOTES

Arcs can be closed using cost = -1.

## EXAMPLE

Visiting all 167 schools (North Carolina):

```sh
# North Carolina

# prepare network by connecting schools to streets
v.net -c input=streets_wake points=schools_wake output=streets_schools \
  operation=connect alayer=1 nlayer=2 thresh=1000

# verify data preparation
v.category in=streets_schools op=report
# type       count        min        max
# point          6          1          6

# find the shortest path
v.net.salesman.opt in=streets_schools ccats=1-167 out=schools_tour

# Resulting tour length: 551551.662

# find the shortest path, optimize with genetic algorithm
v.net.salesman.opt in=streets_schools ccats=1-167 out=schools_tour_ga method=ga

# Resulting tour length: 521191.083
# The original tour was 5.8% longer

# find the shortest path, optimize with bootstrapping
v.net.salesman.opt in=streets_schools ccats=1-167 out=schools_tour_bs method=bs

# Resulting tour length: 510693.965
# The original tour was 8.0% longer

```

## SEE ALSO

*[d.path](https://grass.osgeo.org/grass-stable/manuals/d.path.html)*,
*[v.net](https://grass.osgeo.org/grass-stable/manuals/v.net.html)*,
*[v.net.alloc](https://grass.osgeo.org/grass-stable/manuals/v.net.alloc.html)*,
*[v.net.iso](https://grass.osgeo.org/grass-stable/manuals/v.net.iso.html)*,
*[v.net.path](https://grass.osgeo.org/grass-stable/manuals/v.net.path.html)*,
*[v.net.steiner](https://grass.osgeo.org/grass-stable/manuals/v.net.steiner.html)*

## AUTHORS

Radim Blazek, ITC-Irst, Trento, Italy  
Markus Metz  
Documentation: Markus Neteler, Markus Metz

## SOURCE CODE

Available at: [v.net.salesman.opt source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.net.salesman.opt)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.net.salesman.opt))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
