---
name: v.normal
description: Tests for normality for vector points.
keywords: [ vector, statistics, points, point pattern ]
---

# v.normal

Tests for normality for vector points.

=== "Command line"

    **v.normal**
    [**-rl**]
    **map**=*name*
    [**layer**=*string*]
    **tests**=*range* [,*range*,...]
    **column**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.normal map=name tests=range column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.normal***",
        **map**,
        **layer**=*"1"*,
        **tests**,
        **column**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.normal", map="name", tests="range", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_normal*(**map**,
        **layer**=*"1"*,
        **tests**,
        **column**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_normal(map="name", tests="range", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tests**=*range* [,*range*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Lists of tests (1-15)  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g. 1,3-8,13  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use only points in current region  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Lognormality instead of normality  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tests** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lists of tests (1-15)  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g. 1,3-8,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *range*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only points in current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lognormality instead of normality  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **tests** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lists of tests (1-15)  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g. 1,3-8,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *range*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only points in current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lognormality instead of normality  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.normal* computes tests of normality on vector points.

## NOTES

The tests that *v.normal* performs are indexed below. The tests that are
performed are specified by giving an index, ranges of indices, or
multiple thereof.

1. Sample skewness and kurtosis
2. Geary's a-statistic and an approximate normal transformation
3. Extreme normal deviates
4. D'Agostino's D-statistic
5. Modified Kuiper V-statistic
6. Modified Watson U^2-statistic
7. Durbin's Exact Test (modified Kolmogorov)
8. Modified Anderson-Darling statistic
9. Modified Cramer-Von Mises W^2-statistic
10. Kolmogorov-Smirnov D-statistic (modified for normality testing)
11. Chi-Square test statistic (equal probability classes) and the number
    of degrees of freedom
12. Shapiro-Wilk W Test
13. Weisberg-Binghams W'' (similar to Shapiro-Francia's W')
14. Royston's extension of W for large samples
15. Kotz Separate-Families Test for Lognormality vs. Normality

## EXAMPLE

Compute the sample skewness and kurtosis, Geary's a-statistic and an
approximate normal transformation, extreme normal deviates, and
Royston's W for the *random* vector points:

```sh
g.region raster=elevation -p
v.random random n=200
v.db.addtable random column="elev double precision"
v.what.rast random rast=elevation column=elev
v.normal random tests=1-3,14 column=elev
```

## SEE ALSO

*[v.univar](v.univar.md)*

## AUTHORS

[James Darrell McCauley](http://mccauley-usa.com/)
[\<darrell@mccauley-usa.com\>](mailto:darrell@mccauley-usa.com),  
when he was at: [Agricultural
Engineering](https://engineering.purdue.edu/ABE/) [Purdue
University](http://www.purdue.edu/)

## SOURCE CODE

Available at: [v.normal source code](https://github.com/OSGeo/grass/tree/main/vector/v.normal)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.normal))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
