---
name: v.stats.py
description: Calculates vector statistics
keywords: [ vector, statistics, shape ]
---

# v.stats.py

Calculates vector statistics

=== "Command line"

    **v.stats.py**
    [**-r**]
    **vector**=*name*
    [**layer**=*integer*]
    [**rasters**=*name* [,*name*,...]]
    [**zones**=*name*]
    [**rprefix**=*string* [,*string*,...]]
    [**skipshape**=*string* [,*string*,...]]
    [**skipunivar**=*string* [,*string*,...]]
    [**shpcsv**=*string*]
    [**rstcsv**=*string* [,*string*,...]]
    [**rstpercentile**=*integer*]
    [**newlayer**=*integer*]
    [**newlayername**=*string*]
    [**newtabname**=*string*]
    [**separator**=*string*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.stats.py vector=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.stats.py***",
        **vector**,
        **layer**=*1*,
        **rasters**=*None*,
        **zones**=*None*,
        **rprefix**=*None*,
        **skipshape**=*"area_id"*,
        **skipunivar**=*"label,all_cells,non_null_cells,null_cells,mean_of_abs,sum,sum_abs"*,
        **shpcsv**=*None*,
        **rstcsv**=*None*,
        **rstpercentile**=*90*,
        **newlayer**=*2*,
        **newlayername**=*None*,
        **newtabname**=*None*,
        **separator**=*";"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.stats.py", vector="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_stats_py*(**vector**,
        **layer**=*1*,
        **rasters**=*None*,
        **zones**=*None*,
        **rprefix**=*None*,
        **skipshape**=*"area_id"*,
        **skipunivar**=*"label,all_cells,non_null_cells,null_cells,mean_of_abs,sum,sum_abs"*,
        **shpcsv**=*None*,
        **rstcsv**=*None*,
        **rstpercentile**=*90*,
        **newlayer**=*2*,
        **newlayername**=*None*,
        **newtabname**=*None*,
        **separator**=*";"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_stats_py(vector="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **vector**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    **layer**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rasters**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster maps  
    **zones**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster zones map  
    **rprefix**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster prefixes  
    **skipshape**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip shape columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area_id*  
    **skipunivar**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip shape columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *label,all_cells,non_null_cells,null_cells,mean_of_abs,sum,sum_abs*  
    **shpcsv**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV with the vector statistics of the shape  
    **rstcsv**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV with the statistics of the raster maps  
    **rstpercentile**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster percentile to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **newlayer**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **newlayername**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    **newtabname**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    **separator**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *;*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of process that will be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Read from existing CSV files  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rasters** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **zones** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster zones map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rprefix** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster prefixes  
    **skipshape** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip shape columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area_id*  
    **skipunivar** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip shape columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *label,all_cells,non_null_cells,null_cells,mean_of_abs,sum,sum_abs*  
    **shpcsv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV with the vector statistics of the shape  
    **rstcsv** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV with the statistics of the raster maps  
    **rstpercentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster percentile to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **newlayer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **newlayername** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    **newtabname** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *;*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of process that will be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Read from existing CSV files  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **vector** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rasters** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **zones** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster zones map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rprefix** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster prefixes  
    **skipshape** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip shape columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *area_id*  
    **skipunivar** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip shape columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *label,all_cells,non_null_cells,null_cells,mean_of_abs,sum,sum_abs*  
    **shpcsv** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV with the vector statistics of the shape  
    **rstcsv** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV with the statistics of the raster maps  
    **rstpercentile** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster percentile to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **newlayer** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **newlayername** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    **newtabname** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;New vector layer that will be add to the vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *;*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of process that will be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Read from existing CSV files  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *v.stats* calculates vector statistics.

## AUTHOR

Pietro Zambelli (University of Trento)

## SOURCE CODE

Available at: [v.stats source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.stats)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.stats))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
