---
name: v.surf.tps
description: Performs thin plate spline interpolation with regularization and covariables.
keywords: [ vector, surface, interpolation, TPS ]
---

# v.surf.tps

Performs thin plate spline interpolation with regularization and covariables.

=== "Command line"

    **v.surf.tps**
    [**-c**]
    **input**=*name*
    [**layer**=*string*]
    [**column**=*name*]
    [**smooth**=*float*]
    [**overlap**=*float*]
    [**min**=*float*]
    [**covars**=*name* [,*name*,...]]
    [**thin**=*float*]
    **output**=*name*
    [**mask**=*name*]
    [**memory**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.surf.tps input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.surf.tps***",
        **input**,
        **layer**=*"1"*,
        **column**=*None*,
        **smooth**=*0*,
        **overlap**=*0.1*,
        **min**=*20*,
        **covars**=*None*,
        **thin**=*1.5*,
        **output**,
        **mask**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.surf.tps", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_surf_tps*(**input**,
        **layer**=*"1"*,
        **column**=*None*,
        **smooth**=*0*,
        **overlap**=*0.1*,
        **min**=*20*,
        **covars**=*None*,
        **thin**=*1.5*,
        **output**,
        **mask**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_surf_tps(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the attribute column with values to be used for interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, z-coordinates are used.  
    **smooth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overlap**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap factor &lt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger value increase the tile overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **min**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points to use for TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **covars**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **thin**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point cloud thinning factor in number of cells of the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum distance between neighboring points for local TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells that are not NULL and not zero are interpolated  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input points are dense clusters separated by empty areas  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the attribute column with values to be used for interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, z-coordinates are used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **smooth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overlap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap factor &lt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger value increase the tile overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points to use for TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **covars** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **thin** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point cloud thinning factor in number of cells of the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum distance between neighboring points for local TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells that are not NULL and not zero are interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input points are dense clusters separated by empty areas  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the attribute column with values to be used for interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given, z-coordinates are used.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **smooth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overlap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap factor &lt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger value increase the tile overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points to use for TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **covars** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **thin** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point cloud thinning factor in number of cells of the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum distance between neighboring points for local TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mask** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells that are not NULL and not zero are interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input points are dense clusters separated by empty areas  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.surf.tps* performs multivariate thin plate spline interpolation with
regularization. The **input** is a 2D or 3D vector *points* map. Values
to interpolate can be the z values of 3D points or the values in a
user-specified attribute column in a 2D or 3D vector map. Output is a
raster map. Optionally, several raster maps can be specified to be used
as covariables which will improve results in areas with few points. The
module can be regarded as a combination of a multiple regression and
spline interpolation.

The **min** options specifies the minimum number of points to be used
for interpolation. If the number of input points is smaller than or
equal to the minimum number of points, global TPS interpolation is used.
If the number of input points is larger than the minimum number of
points, tiled local TPS interpolation is used. Tile sizes are variable
and dependent on the extents of the **min** nearest neighbors when a new
tile is generated.

The **smooth** option can be used to reduce the influence of the splines
and increase the influence of the covariables. Without covariables, the
resulting surface will be smoother. With covariables and a large
smooting value, the resulting surface will be mainly determined by the
multiple regression component.

The **overlap** option controls how much tiles are overlapping when the
**min** option is smaller than the numer of input points. Tiling
artefacts occur with low values for the **min** option and the
**overlap** option. Increasing both options will reduce tiling artefacts
but processing will take more time. Values for the **overlap** option
must be between 0 and 1.

The module works best with evenly spaced sparse points. In case of
highly unevenly spaced points, e.g. remote sensing data with gaps due to
cloud cover, the **thin** option should be used in order to avoid tiling
artefacts, otherwise a high number of minimum points and a large
**overlap** value are required, slowing down the module.

The **memory** option controls only how much memory should be used for
the covariables and the intermediate output. The input points are always
completely loaded to memory.

## EXAMPLES

The computational region setting for the following examples:

```sh
g.region -p rast=elev_state_500m
```

### Basic interpolation

Interpolation of 30 year precipitation normals in the North Carlolina
sample dataset:

```sh
v.surf.tps input=precip_30ynormals_3d output=precip_30ynormals_3d \
           column=annual min=140
```

### Interpolation with a covariable

```sh
v.surf.tps input=precip_30ynormals_3d output=precip_30ynormals_3d \
           column=annual min=140 covars=elev_state_500m
```

### Interpolation with a covariable and smoothing

```sh
v.surf.tps input=precip_30ynormals_3d output=precip_30ynormals_3d \
           column=annual min=140 covars=elev_state_500m smooth=0.1
```

### Tiled interpolation with a covariable and smoothing

```sh
v.surf.tps input=precip_30ynormals_3d output=precip_30ynormals_3d \
           column=annual min=20 covars=elev_state_500m smooth=0.1 \
           overlap=0.1
```

![image-alt](v_surf_tps.png)

*Precipitation computed based on annual normals and elevation as a
covariable*

## REFERENCES

- Hutchinson MF, 1995, Interpolating mean rainfall using thin plate
    smoothing splines. International Journal of Geographical Information
    Systems, 9(4), pp. 385-403
- Wahba G, 1990, Spline models for observational data. In CBMS-NSF
    Regional Conference Series in Applied Mathematics. Philadelpia:
    Society for Industrial and Applied Mathematics

## SEE ALSO

*[v.surf.rst](https://grass.osgeo.org/grass-stable/manuals/v.surf.rst.html),
[v.surf.rst](https://grass.osgeo.org/grass-stable/manuals/v.surf.bspline.html),
[v.surf.idw](https://grass.osgeo.org/grass-stable/manuals/v.surf.idw.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [v.surf.tps source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.surf.tps)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.surf.tps))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
