---
name: v.to.db
description: Populates attribute values from vector features.
keywords: [ vector, attribute table, database, area, azimuth, bounding box, category, compactness, coordinates, fractal, geometry, length, perimeter, sides, sinuous, slope ]
---

# v.to.db

Populates attribute values from vector features.

=== "Command line"

    **v.to.db**
    [**-phsc**]
    **map**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **option**=*string*
    **columns**=*name* [,*name*,...]
    [**units**=*string*]
    [**query_layer**=*string*]
    [**query_column**=*name*]
    [**separator**=*character*]
    **format**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.to.db map=name option=cat columns=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.to.db***",
        **map**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid"*,
        **option**,
        **columns**,
        **units**=*None*,
        **query_layer**=*"1"*,
        **query_column**=*None*,
        **separator**=*"pipe"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.to.db", map="name", option="cat", columns="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_to_db*(**map**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid"*,
        **option**,
        **columns**,
        **units**=*None*,
        **query_layer**=*"1"*,
        **query_column**=*None*,
        **separator**=*"pipe"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_to_db(map="name", option="cat", columns="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (write to)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;For coor valid point/centroid, for length valid line/boundary  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **option**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to upload  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cat, area, compact, fd, perimeter, length, count, coor, start, end, sides, query, slope, sinuous, azimuth, bbox*  
    &nbsp;&nbsp;&nbsp;&nbsp;**cat**: insert new row for each category if doesn't exist yet  
    &nbsp;&nbsp;&nbsp;&nbsp;**area**: area size  
    &nbsp;&nbsp;&nbsp;&nbsp;**compact**: compactness of an area, calculated as compactness = perimeter / (2 \* sqrt(PI \* area))  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: fractal dimension of boundary defining a polygon, calculated as fd = 2 \* (log(perimeter) / log(area))  
    &nbsp;&nbsp;&nbsp;&nbsp;**perimeter**: perimeter length of an area  
    &nbsp;&nbsp;&nbsp;&nbsp;**length**: line length  
    &nbsp;&nbsp;&nbsp;&nbsp;**count**: number of features for each category  
    &nbsp;&nbsp;&nbsp;&nbsp;**coor**: point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**start**: line/boundary starting point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**end**: line/boundary end point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**sides**: categories of areas on the left and right side of the boundary, 'query_layer' is used for area category  
    &nbsp;&nbsp;&nbsp;&nbsp;**query**: result of a database query for all records of the geometry (or geometries) from table specified by 'query_layer' option  
    &nbsp;&nbsp;&nbsp;&nbsp;**slope**: slope steepness of vector line or boundary  
    &nbsp;&nbsp;&nbsp;&nbsp;**sinuous**: line sinuousity, calculated as line length / distance between end points  
    &nbsp;&nbsp;&nbsp;&nbsp;**azimuth**: line azimuth, calculated as angle between North direction and endnode direction at startnode  
    &nbsp;&nbsp;&nbsp;&nbsp;**bbox**: bounding box of area, N,S,E,W  
    **columns**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to populate  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares, radians, degrees*  
    **query_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query layer number or name (read from)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **query_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column used for 'query' option  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g. 'cat', 'count(\*)', 'sum(val)'  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for print mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation), only used when print only flag is also set  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print only  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print header  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only print SQL statements  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print also totals for option length, area, or count  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (write to)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;For coor valid point/centroid, for length valid line/boundary  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **option** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to upload  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cat, area, compact, fd, perimeter, length, count, coor, start, end, sides, query, slope, sinuous, azimuth, bbox*  
    &nbsp;&nbsp;&nbsp;&nbsp;**cat**: insert new row for each category if doesn't exist yet  
    &nbsp;&nbsp;&nbsp;&nbsp;**area**: area size  
    &nbsp;&nbsp;&nbsp;&nbsp;**compact**: compactness of an area, calculated as compactness = perimeter / (2 \* sqrt(PI \* area))  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: fractal dimension of boundary defining a polygon, calculated as fd = 2 \* (log(perimeter) / log(area))  
    &nbsp;&nbsp;&nbsp;&nbsp;**perimeter**: perimeter length of an area  
    &nbsp;&nbsp;&nbsp;&nbsp;**length**: line length  
    &nbsp;&nbsp;&nbsp;&nbsp;**count**: number of features for each category  
    &nbsp;&nbsp;&nbsp;&nbsp;**coor**: point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**start**: line/boundary starting point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**end**: line/boundary end point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**sides**: categories of areas on the left and right side of the boundary, 'query_layer' is used for area category  
    &nbsp;&nbsp;&nbsp;&nbsp;**query**: result of a database query for all records of the geometry (or geometries) from table specified by 'query_layer' option  
    &nbsp;&nbsp;&nbsp;&nbsp;**slope**: slope steepness of vector line or boundary  
    &nbsp;&nbsp;&nbsp;&nbsp;**sinuous**: line sinuousity, calculated as line length / distance between end points  
    &nbsp;&nbsp;&nbsp;&nbsp;**azimuth**: line azimuth, calculated as angle between North direction and endnode direction at startnode  
    &nbsp;&nbsp;&nbsp;&nbsp;**bbox**: bounding box of area, N,S,E,W  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to populate  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares, radians, degrees*  
    **query_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query layer number or name (read from)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **query_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column used for 'query' option  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g. 'cat', 'count(\*)', 'sum(val)'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for print mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation), only used when print only flag is also set  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *h*, *s*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print only  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print header  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only print SQL statements  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also totals for option length, area, or count  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name (write to)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;For coor valid point/centroid, for length valid line/boundary  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **option** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value to upload  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cat, area, compact, fd, perimeter, length, count, coor, start, end, sides, query, slope, sinuous, azimuth, bbox*  
    &nbsp;&nbsp;&nbsp;&nbsp;**cat**: insert new row for each category if doesn't exist yet  
    &nbsp;&nbsp;&nbsp;&nbsp;**area**: area size  
    &nbsp;&nbsp;&nbsp;&nbsp;**compact**: compactness of an area, calculated as compactness = perimeter / (2 \* sqrt(PI \* area))  
    &nbsp;&nbsp;&nbsp;&nbsp;**fd**: fractal dimension of boundary defining a polygon, calculated as fd = 2 \* (log(perimeter) / log(area))  
    &nbsp;&nbsp;&nbsp;&nbsp;**perimeter**: perimeter length of an area  
    &nbsp;&nbsp;&nbsp;&nbsp;**length**: line length  
    &nbsp;&nbsp;&nbsp;&nbsp;**count**: number of features for each category  
    &nbsp;&nbsp;&nbsp;&nbsp;**coor**: point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**start**: line/boundary starting point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**end**: line/boundary end point coordinates, X,Y or X,Y,Z  
    &nbsp;&nbsp;&nbsp;&nbsp;**sides**: categories of areas on the left and right side of the boundary, 'query_layer' is used for area category  
    &nbsp;&nbsp;&nbsp;&nbsp;**query**: result of a database query for all records of the geometry (or geometries) from table specified by 'query_layer' option  
    &nbsp;&nbsp;&nbsp;&nbsp;**slope**: slope steepness of vector line or boundary  
    &nbsp;&nbsp;&nbsp;&nbsp;**sinuous**: line sinuousity, calculated as line length / distance between end points  
    &nbsp;&nbsp;&nbsp;&nbsp;**azimuth**: line azimuth, calculated as angle between North direction and endnode direction at startnode  
    &nbsp;&nbsp;&nbsp;&nbsp;**bbox**: bounding box of area, N,S,E,W  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to populate  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares, radians, degrees*  
    **query_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query layer number or name (read from)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **query_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column used for 'query' option  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g. 'cat', 'count(\*)', 'sum(val)'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator for print mode  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation), only used when print only flag is also set  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *h*, *s*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print only  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print header  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only print SQL statements  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print also totals for option length, area, or count  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.to.db* loads vector map features or metrics into a database table, or
prints them (or the SQL queries used to obtain them) in a form of a
human-readable report. For uploaded/printed category values '-1' is used
for 'no category' and 'null'/'-' if category cannot be found or multiple
categories were found. For line azimuths '-1' is used for closed lines
(start equals end).

## NOTES

Measures of lengths and areas are always reported in meters, unless the
*unit* parameter is set. The units *miles*, *feet*, *meters* and
*kilometers* are square for *option=area*.

Feet and acre units are always reported in their common versions (i.e.
the International Foot, exactly 5280 feet in a mile), even when the
coordinate reference system's standard map unit is the US Survey foot.

When calculating perimeters in Latitude-Longitude CRS, the geodesic
distance between the vertices is used.

When using *option=coor* on a vector area map, only coordinates of
centroids with unique category will be reported.

When using *option=bbox* on a vector area map with more than one feature
per category value, the results corresponds to the bounding box of all
features of same category taken together.

Line azimuth is calculated as angle from the North direction to the line
endnode direction at the line statnode. By default it's reported in
decimal degrees (0-360, CW) but it also may be reported in radians with
*unit=radians*. Azimuth value **-1** is used to report closed line with
it's startnode and endnode being in same place. Azimuth values make
sense only if every vector line has only one entry in database (unique
CAT value).

If the module is apparently slow *and* the map attributes are stored in
an external DBMS such as PostgreSQL, it is highly recommended to create
an index on the key (category) column.

Uploading the vector map attributes to a database requires a table
attached to a given input vector *layer*. The **print only** (**-p**)
mode doesn't require a table. Use *[db.execute](db.execute.md)* or
*[v.db.addtable](v.db.addtable.md)* to create a table if needed.

Updating the table has to be done column-wise. The *column* will be
created in the table if it doesn't already exist, except when using the
**print only** (**-p**) mode. If the *column* exists, the
**--overwrite** flag is required to overwrite it.

## EXAMPLES

### Updating attribute tables

Upload category numbers to attribute table (used for new map):  

```sh
v.to.db map=soils type=centroid option=cat
```

Upload polygon areas to corresponding centroid record in the attribute
table:  

```sh
v.to.db map=soils type=centroid option=area columns=area_size unit=h
```

Upload line lengths (in meters) of each vector line to attribute table
(use *v.category* in case of missing categories):  

```sh
v.to.db map=roads option=length type=line columns=linelength units=me
```

Upload x and y coordinates from vector geometry to attribute table:  

```sh
v.to.db map=pointsmap option=coor columns=x,y
```

Upload x, y and z coordinates from vector geometry to attribute table:  

```sh
v.to.db map=pointsmap option=coor columns=x,y,z
```

Transfer attributes from a character column (with numeric contents) to a
new integer column:  

```sh
v.db.addcolumn usa_income_employment2002 col="FIPS_NUM integer"
v.to.db usa_income_employment2002 option=query columns=FIPS_NUM query_column=STATE_FIPS
```

Upload category numbers of left and right area, to an attribute table of
boundaries common for the areas:  

```sh
# add categories for boundaries of the input vector map, in layer 2:
v.category soils out=mysoils layer=2 type=boundary option=add
# add a table with columns named "left" and "right" to layer 2 of the input
# vector map:
v.db.addtable mysoils layer=2 columns="left integer,right integer"
# upload categories of left and right areas:
v.to.db mysoils option=sides columns=left,right layer=2
# display the result:
v.db.select mysoils layer=2
```

Compute *D_L*, the Fractal Dimension (Mandelbrot, 1982), of the
boundary defining a polygon based on the formula:  
`D = 2 * (log perimeter) / (log area):`  

```sh
g.copy vect=soils,mysoils
v.db.addcolumn mysoils col="d double precision"
v.to.db mysoils option=fd column="d"

g.region vector=mysoils res=50
v.to.rast input=mysoils output=soils_fd type=area use=attr attribute_column=d
r.colors map=soils_fd color=gyr

d.mon wx0
d.rast.leg soils_fd
d.vect mysoils type=boundary
```

### Printing reports

Report x,y,z coordinates of points in the input vector map:  

```sh
v.to.db -p bugsites option=coor type=point
```

Report all area sizes of the input vector map:  

```sh
v.to.db -p soils option=area type=boundary units=h
```

Report all area sizes of the input vector map, in hectares, sorted by
category number (requires GNU *sort* utility installed):  

```sh
v.to.db -p soils option=area type=boundary units=h | sort -n
```

Report all line lengths of the input vector map, in kilometers:  

```sh
v.to.db -p roads option=length type=line units=k
```

Report number of features for each category in the input vector map:  

```sh
v.to.db -p roads option=count type=line
```

Report all area sizes of the input vector map using python:

```python
import grass.script as gs

data = gs.parse_command(
    "v.to.db", map="busroute6", flags="p", option="length", type="line", format="json"
)
print(data["totals"])
```

Possible output:

```text
{'length': 10426.657857419743}
```

The whole JSON may look like this:

```json
{
    "units": {
        "length": "meters"
    },
    "totals": {
        "length": 10426.657857419743
    },
    "records": [
        {
            "category": 1,
            "length": 4554.943058982206
        },
        {
            "category": 2,
            "length": 5871.714798437538
        }
    ]
}
```

## REFERENCES

- Mandelbrot, B. B. (1982). The fractal geometry of nature. New
  York: W. H. Freeman.
- Xu, Y. F. & Sun, D. A. (2005). Geotechnique 55, No. 9, 691-695

## SEE ALSO

*[d.what.vect](d.what.vect.md), [db.execute](db.execute.md),
[v.category](v.category.md), [v.db.addtable](v.db.addtable.md),
[v.db.addcolumn](v.db.addcolumn.md), [v.db.connect](v.db.connect.md),
[v.distance](v.distance.md), [v.report](v.report.md),
[v.univar](v.univar.md), [v.what](v.what.md)*

## AUTHORS

Radim Blazek, ITC-irst, Trento, Italy  
Line sinuosity implemented by Wolf Bergenheim

## SOURCE CODE

Available at: [v.to.db source code](https://github.com/OSGeo/grass/tree/main/vector/v.to.db)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.to.db))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
