---
name: v.what.rast.multi.py
description: Uploads values of multiple rasters at positions of vector points to the table.
keywords: [ vector, sampling, raster, position, querying, attribute table, surface information ]
---

# v.what.rast.multi.py

Uploads values of multiple rasters at positions of vector points to the table.

=== "Command line"

    **v.what.rast.multi.py**
    [**-im**]
    **map**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **raster**=*name* [,*name*,...]
    [**columns**=*name* [,*name*,...]]
    [**where**=*sql_query*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.what.rast.multi.py map=name raster=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.what.rast.multi.py***",
        **map**,
        **layer**=*"1"*,
        **type**=*"point"*,
        **raster**,
        **columns**=*None*,
        **where**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.what.rast.multi.py", map="name", raster="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_what_rast_multi_py*(**map**,
        **layer**=*"1"*,
        **type**=*"point"*,
        **raster**,
        **columns**=*None*,
        **where**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_what_rast_multi_py(map="name", raster="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **raster**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster map to be queried  
    **columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of attribute columns to be updated with the query result  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolate values from the nearest four cells  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Retain mapset name  
    &nbsp;&nbsp;&nbsp;&nbsp;When no column names are provided, the column names are created using the names of the input layers. Using this flag will retain the mapset part of the name (if given), but replacing the @ for an underscore.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of attribute columns to be updated with the query result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Interpolate values from the nearest four cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Retain mapset name  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;When no column names are provided, the column names are created using the names of the input layers. Using this flag will retain the mapset part of the name (if given), but replacing the @ for an underscore.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point*  
    **raster** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing raster map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of attribute columns to be updated with the query result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Interpolate values from the nearest four cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Retain mapset name  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;When no column names are provided, the column names are created using the names of the input layers. Using this flag will retain the mapset part of the name (if given), but replacing the @ for an underscore.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.what.rast.multi* retrieves raster value from a given set of raster
map for each point or centroid stored in a given vector map. It can
update a **column** in the linked vector attribute table with the
retrieved raster cell value or print it. It is essentially a wrapper
around *v.what.rast*.

The column type needs to be numeric (integer, float, double, ...). If
the column doesn't exist in the vector attribute table than the module
will create the new column of type corresponding with the input raster
map.

If the **-p** flag is used, then the attribute table is not updated and
the results are printed to standard output.

If the **-i** flag is used, then the value to be uploaded to the
database is interpolated from the four nearest raster cells values using
an inverse distance weighting method (IDW). This is useful for cases
when the vector point density is much higher than the raster cell size.

## NOTES

Points and centroid with shared category number cannot be processed. To
solved this, unique categories may be added with
*[v.category](https://grass.osgeo.org/grass-stable/manuals/v.category.html)*
in a separate layer.

If multiple points have the same category, the attribute value is set to
NULL. If the raster value is NULL, then attribute value is set to NULL.

*v.what.rast.multi* operates on the attribute table. To modify the
vector geometry instead, use
*[v.drape](https://grass.osgeo.org/grass-stable/manuals/v.drape.html)*.

Categories and values are output unsorted with the print flag. To sort
them pipe the output of this module into the UNIX `sort` tool
(`sort -n`). If you need coordinates, after sorting use
*[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html)*
and the UNIX `paste` tool (`paste -d'|'`). In the case of a NULL result,
a "`*`" will be printed in lieu of the value.

The interpolation flag is only useful for continuous value raster maps,
if a categorical raster is given as input the results will be nonsense.
Since the search window is limited to four raster cells there may still
be raster cell-edge artifacts visible in the results, this compromise
has been made for processing speed. If one or more of the nearest four
raster cells is NULL, then only the raster cells containing values will
be used in the weighted average.

## EXAMPLES

### Transferring raster values into existing attribute table of vector points map

Reading values from raster map at position of vector points, writing
these values into a column of the attribute table connected to the
vector map:

```sh
# set computational region
g.region raster=slope -p

# work on copy of original geodetic points map
g.copy vector=geodetic_pts,mygeodetic_pts

# query raster cells
v.what.rast.multi map=mygeodetic_pts raster=elev_state_500m,slope,aspect columns=elevation,slope,aspect

# print results
v.db.select map=mygeodetic_pts columns=elevatin,slope,aspect separator=comma where="SLOPE > 0"

```

## SEE ALSO

*[v.what.rast](https://grass.osgeo.org/grass-stable/manuals/v.what.rast.html)*

## AUTHOR

Pierre Roudier

## SOURCE CODE

Available at: [v.what.rast.multi source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.what.rast.multi)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.what.rast.multi))  
Latest change: Sunday Aug 17 07:42:53 2025 in commit [d05acfb](https://github.com/OSGeo/grass-addons/commit/d05acfb92c30bdcd789aa68bf49daa0cd2752de3)
