#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = x86_64-w64-mingw32-gcc
CXX                 = x86_64-w64-mingw32-g++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /usr
exec_prefix         = ${prefix}
ARCH                = x86_64-w64-mingw32
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}/grass85

GRASS_HOME          = /c/usr/local/src/grass
RUN_GISBASE         = C:/usr/local/src/grass/dist.x86_64-w64-mingw32

GRASS_VERSION_MAJOR = 8
GRASS_VERSION_MINOR = 5
GRASS_VERSION_RELEASE = 0dev
GRASS_VERSION_DATE  = 2025
GRASS_VERSION_GIT   = b327e821ad

STRIPFLAG           = 
LD_SEARCH_FLAGS     = 
LD_LIBRARY_PATH_VAR = PATH

#generate static (ST) or shared (SH)
GRASS_LIBRARY_TYPE  = shlib

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = x86_64-w64-mingw32-gcc -shared
SHLIB_LDX           = x86_64-w64-mingw32-g++ -shared
SHLIB_LDFLAGS       = 
SHLIB_CFLAGS        = 
SHLIB_SUFFIX        = .dll
EXE                 = .exe

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            =   -I/c/OSGeo4W/include
CFLAGS              = -g -O2 
CXXFLAGS            = -g -O2
INCLUDE_DIRS        =  -I/c/OSGeo4W/include
LINK_FLAGS          =   -Wl,--export-dynamic,--enable-runtime-pseudo-reloc  -L/c/OSGeo4W/lib -L/c/OSGeo4W/bin

DLLIB               = -ldl
XCFLAGS             = 
XLIBPATH            = 
XLIB                =  
XEXTRALIBS          = 
USE_X11             = 

MATHLIB             = 
ICONVLIB            = -liconv
INTLLIB             = -lintl
SOCKLIB             = 

#ZLIB:
ZLIB                =  -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#BZIP2:
BZIP2LIB            =  -lbz2 
BZIP2INCPATH        = 
BZIP2LIBPATH        = 

#ZSTD:
ZSTDLIB             =  -lzstd 
ZSTDINCPATH         = 
ZSTDLIBPATH         = 

DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         = 
HISTORYLIB          = 

#PostgreSQL:
PQINCPATH           = 
PQLIBPATH           = 
PQLIB               = 
USE_POSTGRES        = 

#MySQL:
MYSQLINCPATH        = 
MYSQLLIBPATH        = 
MYSQLLIB            = 
MYSQLDLIB           = 

#SQLite:
SQLITEINCPATH       = 
SQLITELIBPATH       = 
SQLITELIB           =  -lsqlite3 

#ODBC:
ODBCINC             = 
ODBCLIB             = 

#Image formats:
PNGINC              = -I/c/OSGeo4W/include/libpng16
PNGLIB              = -L/c/OSGeo4W/lib -lpng16 -lm -lz
USE_PNG             = 1

TIFFINCPATH         = 
TIFFLIBPATH         = 
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLLIB           =   -lopengl32 
OPENGLULIB          =   -lglu32 
OPENGL_X11          = 
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 1
USE_OPENGL          = 1

#FFTW:
FFTWINC             = 
FFTWLIB             =  -lfftw3 

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = -lcblas 
BLASINC             = 
LAPACKLIB           = -llapacke 
LAPACKINC           = 

#LIBSVM
LIBSVM_LIB          = 
LIBSVM_INC          = 
USE_LIBSVM          = 

#GDAL/OGR
GDALLIBS            = /c/OSGeo4W/lib/gdal_i.lib
GDALCFLAGS          = -I/c/OSGeo4W/include
USE_GDAL            = 1
USE_OGR             = 1

#NetCDF
NETCDFLIBS          = -L/C/OSGeo4W/lib -lnetcdf
NETCDFCFLAGS        = -I/C/OSGeo4W/include
USE_NETCDF          = 1

#LAS LiDAR through libLAS
LASLIBS             = /c/OSGeo4W/lib/liblas_c.lib
LASCFLAGS           = 
LASINC              = -I/c/OSGeo4W/include
USE_LIBLAS          = 1

#LAS LiDAR through PDAL
PDALLIBS             = 
PDALINC              = 
USE_PDAL             = 

#GEOS
GEOSLIBS            = /c/OSGeo4W/lib/geos_c.lib -lgeos_c 
GEOSCFLAGS          = -I/c/OSGeo4W/include
USE_GEOS            = 1

#FreeType:
FTINC               =  -I/c/OSGeo4W/include/freetype2
FTLIB               =  -lfreetype 

#PROJ.4:
PROJINC             = 
PROJLIB             =  -lproj 
PROJSHARE           = /usr/share/proj

#cairo
CAIROINC                  = 
CAIROLIB                  =  -lcairo 
USE_CAIRO                 = 1
CAIRO_HAS_XRENDER         = 
CAIRO_HAS_XRENDER_SURFACE = 

#Python
PYTHON              = python3

#regex
REGEXINCPATH        = 
REGEXLIBPATH        = 
REGEXLIB            =  -lregex 
USE_REGEX           = 1

#pthreads
PTHREADINCPATH      = 
PTHREADLIBPATH      = 
PTHREADLIB          = 
USE_PTHREAD         = 

#OpenMP
OPENMP_INCPATH      = 
OPENMP_LIBPATH      = 
OPENMP_LIB          = 
OPENMP_CFLAGS       = 
USE_OPENMP          = 

#OpenCL
OCLINCPATH          = 
OCLLIBPATH          = 
OCLLIB              = 
USE_OPENCL          = 

#i18N
HAVE_NLS            = 1

#Large File Support (LFS)
USE_LARGEFILES      = @USE_LARGEFILES@
LFS_CFLAGS          = -D_FILE_OFFSET_BITS=64

#BSD sockets
HAVE_SOCKET         = 

MINGW		    = yes
WINDRES		    = windres
MACOSX_APP	    = 
MACOSX_ARCHS        = 
MACOSX_SDK          = 

# Cross compilation
CROSS_COMPILING     = 
