---
name: d.vect.thematic
description: Displays a thematic vector map in the active graphics frame.
keywords: [ display, cartography, choropleth map, legend ]
---

# d.vect.thematic

Displays a thematic vector map in the active graphics frame.

=== "Command line"

    **d.vect.thematic**
    [**-lnes**]
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**breaks**=*string* [,*string*,...]]
    [**algorithm**=*string*]
    [**nclasses**=*integer*]
    **colors**=*string* [,*string*,...]
    [**where**=*sql_query*]
    [**boundary_width**=*integer*]
    [**boundary_color**=*name*]
    [**icon**=*string*]
    [**size**=*float*]
    [**icon_line**=*string*]
    [**icon_area**=*string*]
    [**legend_title**=*string*]
    [**legendfile**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.vect.thematic map=name column=name algorithm=int colors=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.vect.thematic***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **breaks**=*None*,
        **algorithm**=*None*,
        **nclasses**=*None*,
        **colors**,
        **where**=*None*,
        **boundary_width**=*1*,
        **boundary_color**=*"black"*,
        **icon**=*"basic/x"*,
        **size**=*5*,
        **icon_line**=*"legend/line"*,
        **icon_area**=*"legend/area"*,
        **legend_title**=*None*,
        **legendfile**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.vect.thematic", map="name", column="name", algorithm="int", colors="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_vect_thematic*(**map**,
        **layer**=*"1"*,
        **column**,
        **breaks**=*None*,
        **algorithm**=*None*,
        **nclasses**=*None*,
        **colors**,
        **where**=*None*,
        **boundary_width**=*1*,
        **boundary_color**=*"black"*,
        **icon**=*"basic/x"*,
        **size**=*5*,
        **icon_line**=*"legend/line"*,
        **icon_area**=*"legend/area"*,
        **legend_title**=*None*,
        **legendfile**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_vect_thematic(map="name", column="name", algorithm="int", colors="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number. If -1, all layers are displayed.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be classified  
    **breaks**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Class breaks, without minimum and maximum  
    **algorithm**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm to use for classification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, std, qua, equ, dis*  
    &nbsp;&nbsp;&nbsp;&nbsp;**int**: simple intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;**std**: standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;**qua**: quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**equ**: equiprobable (normal distribution)  
    &nbsp;&nbsp;&nbsp;&nbsp;**dis**: discontinuities  
    **nclasses**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes to define  
    **colors**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Colors (one per class)  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **boundary_width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **boundary_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **icon**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point and centroid symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/x*  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **icon_line**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend symbol for lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/line*  
    **icon_area**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend symbol for areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/area*  
    **legend_title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thematic map title  
    **legendfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;[DEPRECATED] Output legend file  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create legend information and send to stdout  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not draw map, only output the legend information  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;[DEPRECATED] When printing legend info, include extended statistical info from classification algorithm  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not show this layer in vector legend  
  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number. If -1, all layers are displayed.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be classified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **breaks** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Class breaks, without minimum and maximum  
    **algorithm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm to use for classification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, std, qua, equ, dis*  
    &nbsp;&nbsp;&nbsp;&nbsp;**int**: simple intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;**std**: standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;**qua**: quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**equ**: equiprobable (normal distribution)  
    &nbsp;&nbsp;&nbsp;&nbsp;**dis**: discontinuities  
    **nclasses** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes to define  
    **colors** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colors (one per class)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **boundary_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **boundary_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point and centroid symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/x*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **icon_line** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend symbol for lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/line*  
    **icon_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend symbol for areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/area*  
    **legend_title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thematic map title  
    **legendfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;[DEPRECATED] Output legend file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *n*, *e*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create legend information and send to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not draw map, only output the legend information  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[DEPRECATED] When printing legend info, include extended statistical info from classification algorithm  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not show this layer in vector legend  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number. If -1, all layers are displayed.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be classified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **breaks** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Class breaks, without minimum and maximum  
    **algorithm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Algorithm to use for classification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, std, qua, equ, dis*  
    &nbsp;&nbsp;&nbsp;&nbsp;**int**: simple intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;**std**: standard deviations  
    &nbsp;&nbsp;&nbsp;&nbsp;**qua**: quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;**equ**: equiprobable (normal distribution)  
    &nbsp;&nbsp;&nbsp;&nbsp;**dis**: discontinuities  
    **nclasses** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes to define  
    **colors** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colors (one per class)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **boundary_width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **boundary_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point and centroid symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/x*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **icon_line** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend symbol for lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/line*  
    **icon_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Legend symbol for areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/area*  
    **legend_title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thematic map title  
    **legendfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;[DEPRECATED] Output legend file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *n*, *e*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create legend information and send to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not draw map, only output the legend information  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[DEPRECATED] When printing legend info, include extended statistical info from classification algorithm  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not show this layer in vector legend  
  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.vect.thematic* draws thematic choropleth vector maps based on an
attribute column or an expression involving several columns. It takes a
list of class **breaks** (excluding the minimum and maximum values) and
a list of **colors** to apply to the classes (has to be the number of
class breaks + 1).

Instead of a list of class breaks, the user can also chose a
classification **algorithm** and a number of classes (**nbclasses**).
See the *[v.class](v.class.md)* for more information on these different
algorithms.

## NOTES

The **-l** flag instructs the module to print legend information in
vector legend format as described in *[d.legend.vect](d.legend.vect.md)*
to standard output for further use in graphical software. When combined
with the verbose flag, the legend information will be extended with some
additional statistical information. If the **-n** flag is set, the
module will only print the legend information without drawing the map.

Option **legendfile**, is deprecated, instead use the GRASS_LEGEND_FILE
environmental variable (see *[d.legend.vect](d.legend.vect.md)*) to save
legend into a file. Flag **-e** is deprecated, instead use verbose flag.

## EXAMPLES

### Thematic map with classes

```sh
d.vect.thematic -l map=communes3 column=pop \
  breaks=111393.250000,222785.500000,334177.750000 \
  colors="255:0:0,0:255:0,0:0:255,0,0,0"
```

### Thematic map with calculated class breaks

The following example uses a calculated attribute (`density = pop/area`)
and the standard deviation algorithm to calculate class breaks for 5
classes:

```sh
d.vect.thematic -l map=communes2 column=pop/area algorithm=std \
  nbclasses=5 colors="0:0:255,50:100:255,255:100:50,255:0:0,156:0:0"
```

### Thematic map with legend

Example for the North Carolina sample dataset, colorizing basin polygons
by average elevation and displaying school capacity:

```sh
# create watersheds from elevation map
g.region raster=elevation
r.watershed elevation=elevation threshold=10000 basin=basins_10k

# convert raster to vector
r.to.vect input=basins_10k output=basins_10k type=area column=basin_num

# upload raster statistics to each polygon in vector map
v.rast.stats map=basins_10k raster=elevation column_prefix=elev

# open a graphical display
d.mon wx0

# draw thematic polygons and specify legend title
d.vect.thematic map=basins_10k column=elev_average algorithm=int \
  nclasses=5 colors=0:195:176,39:255:0,251:253:0,242:127:11,193:126:60 \
  legend_title="Average elevation (m)"

# draw thematic points and specify legend title
d.vect.thematic map=schools_wake@PERMANENT column=CORECAPACI algorithm=std \
  nclasses=3 colors=149:203:255,45:143:240,0:81:161 icon=basic/circle size=15 \
  legend_title="School capacity"

# and finally draw legend
d.legend.vect -b at=2,80 font=Sans symbol_size=25
```

![d_vect_thematic example](d_vect_thematic.png)  
*Thematic map of average elevation and school capacity*

## SEE ALSO

*[v.class](v.class.md), [d.legend.vect](d.legend.vect.md),
[d.vect](d.vect.md), [d.graph](d.graph.md), [v.univar](v.univar.md)*

Check also Python module from AddOns:
*[d.vect.thematic2](https://grass.osgeo.org/grass8/manuals/addons/d.vect.thematic2.html)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [d.vect.thematic source code](https://github.com/OSGeo/grass/tree/main/display/d.vect.thematic)
([history](https://github.com/OSGeo/grass/commits/main/display/d.vect.thematic))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
