---
name: d.what.vect.py
description: Allows the user to interactively query vector map layers at user-selected locations.
keywords: [ display, vector ]
---

# d.what.vect.py

Allows the user to interactively query vector map layers at user-selected locations.

=== "Command line"

    **d.what.vect.py**
    **map**=*name* [,*name*,...]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.what.vect.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.what.vect.py***",
        **map**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.what.vect.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_what_vect_py*(**map**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_what_vect_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source(s) for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.what.vect* outputs the category value(s) associated with
user-specified location(s) in user-specified vector map layer(s). The
active monitor can be selected with *d.mon*.

## SEE ALSO

*[d.what.rast](d.what.rast.md), [d.redraw](d.redraw.md),
[d.erase](d.erase.md), [d.rast](d.rast.md), [d.vect](d.vect.md),
[d.mon](d.mon.md)*

## AUTHOR

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [d.what.vect source code](https://github.com/OSGeo/grass/tree/main/scripts/d.what.vect)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.what.vect))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
