---
name: db.csw.harvest.py
description: CSW database manager
keywords: [ csw, metadata, harvesting ]
---

# db.csw.harvest.py

CSW database manager

=== "Command line"

    **db.csw.harvest.py**
    **source**=*string*
    **destination**=*string*
    [**max**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.csw.harvest.py source=string destination=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.csw.harvest.py***",
        **source**,
        **destination**,
        **max**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.csw.harvest.py", source="string", destination="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_csw_harvest_py*(**source**,
        **destination**,
        **max**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_csw_harvest_py(source="string", destination="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **source**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;uri source  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw source  
    **destination**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;uri destination  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw destination  
    **max**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;max records  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw destination  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **source** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;uri source  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw source  
    **destination** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;uri destination  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw destination  
    **max** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;max records  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw destination  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **source** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;uri source  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw source  
    **destination** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;uri destination  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw destination  
    **max** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;max records  
    &nbsp;&nbsp;&nbsp;&nbsp;uri to csw destination  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *db.csw.harvest* allows to harvest metadata between two
catalogues.

## NOTES

For dependencies and installation instructions see [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).
For importing metadata to local server transactions must be allowed. The
parameter "transactions" is stored in the configure file "default.cfq"
(by default in pycsw installation folder).

## EXAMPLES

Harvesting of a remote catalogue to local:

```sh
db.csw.harvest source=https://geodati.gov.it/RNDT/csw destination=http://localhost:8000/
```

## SEE ALSO

*[r.info](https://grass.osgeo.org/grass-stable/manuals/r.info.html),
[v.info.iso](v.info.iso.md), [g.gui.metadata](g.gui.metadata.md),
[g.gui.cswbrowser](g.gui.cswbrowser.md), [db.csw.admin](db.csw.admin),
[db.csw.run](db.csw.run)*

See also related [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## AUTHOR

Matej Krejci, [OSGeoREL](https://geo.fsv.cvut.cz/gwiki/osgeorel) at the
Czech Technical University in Prague, developed during [Google Summer of
Code 2015](https://trac.osgeo.org/grass/wiki/GSoC/2014/MetadataForGRASS)
(mentors: Martin Landa)

## SOURCE CODE

Available at: [db.csw.harvest source code](https://github.com/OSGeo/grass-addons/tree/grass8/wxpython/wx.metadata/db.csw.harvest)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/wxpython/wx.metadata/db.csw.harvest))  
Latest change: Saturday Aug 09 10:30:07 2025 in commit [4b03638](https://github.com/OSGeo/grass-addons/commit/4b036388512a511715f972d46f3245515b15de42)
