---
name: db.join.py
description: Joins a database table to another database table.
keywords: [ database, attribute table ]
---

# db.join.py

Joins a database table to another database table.

=== "Command line"

    **db.join.py**
    **table**=*name*
    **column**=*name*
    [**database**=*name*]
    [**driver**=*name*]
    **other_table**=*name*
    **other_column**=*name*
    [**subset_columns**=*name* [,*name*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.join.py table=name column=name other_table=name other_column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.join.py***",
        **table**,
        **column**,
        **database**=*None*,
        **driver**=*None*,
        **other_table**,
        **other_column**,
        **subset_columns**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.join.py", table="name", column="name", other_table="name", other_column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_join_py*(**table**,
        **column**,
        **database**=*None*,
        **driver**=*None*,
        **other_table**,
        **other_column**,
        **subset_columns**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_join_py(table="name", column="name", other_table="name", other_column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Table to which to join other table  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Identifier column (e.g.: cat) in the table to be used for join  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **other_table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Other table name  
    **other_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Identifier column (e.g.: id) in the other table used for join  
    **subset_columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Subset of columns from the other table  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Table to which to join other table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Identifier column (e.g.: cat) in the table to be used for join  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **other_table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Other table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **other_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Identifier column (e.g.: id) in the other table used for join  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **subset_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subset of columns from the other table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Table to which to join other table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Identifier column (e.g.: cat) in the table to be used for join  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **other_table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Other table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **other_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Identifier column (e.g.: id) in the other table used for join  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **subset_columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subset of columns from the other table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.join* joins the content of one attribute table into another
attribute table through common attributes.

## NOTES

*db.join* is a front-end to *db.execute* to allow easier usage. The
attribute table must be stored in a SQL database (SQLite, PostgreSQL,
MySQL, ODBC, ...). The DBF backend is not supported. Tables can be
imported with *db.in.ogr*.

## EXAMPLES

```sh
# join soils_legend into mysoils attribute table
db.join mysoils col=label otable=soils_legend ocol=shortname

# verification of join
db.select mysoils
cat|label|id|shortname|longname
1|Aab|||
2|Ba|2|Ba|Barnum silt loam
3|Bb|3|Bb|Barnum silt loam, channeled
4|BcB|4|BcB|Boneek silt loam, 2 to 6
5|BcC|5|BcC|Boneek silt loam, 6 to 9
...
```

## SEE ALSO

*[db.execute](https://grass.osgeo.org/grass-stable/manuals/db.execute.html),
[db.in.ogr](https://grass.osgeo.org/grass-stable/manuals/db.in.ogr.html),
[db.select](https://grass.osgeo.org/grass-stable/manuals/db.select.html),
[v.db.join](https://grass.osgeo.org/grass-stable/manuals/v.db.join.html),
[v.db.update](https://grass.osgeo.org/grass-stable/manuals/v.db.update.html)  
[GRASS SQL
interface](https://grass.osgeo.org/grass-stable/manuals/sql.html)*

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [db.join source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/db/db.join)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/db/db.join))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
