---
name: g.gui.cswbrowser.py
description: Graphical CSW metadata browser.
keywords: [ general, GUI, metadata ]
---

# g.gui.cswbrowser.py

Graphical CSW metadata browser.

=== "Command line"

    **g.gui.cswbrowser.py**
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.cswbrowser.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.cswbrowser.py***",
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.cswbrowser.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_cswbrowser_py*(        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_cswbrowser_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.gui.cswbrowser* supports searching and browsing metadata catalogs
based on [Catalogue Service
(CSW)](https://www.ogc.org/publications/standard/cat/) standard .

The module allows to setting up connection to csw by uri and search
metadata using advanced filter.

## NOTES

For dependencies and installation instructions see the dedicated [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

### Setting up connection

After start g.gui.cswbrowser the connection manager is initialized by
default connection file which includes some well known catalogs.
Connection manager allows to add, to delete and to load connection from
xml file.

### Search and browse catalog

Searching and browsing panel allows to setup request with using custom
filter.

## EXAMPLES

### Query filter

The filter can be defined by limitation of area by bounding box which
can be set by GRASS region or manualy.

### Bounding box

- Bounding box  
    Bounding box defined spatial extent for limitation of area. Button
    "Map extends" allows to set up values from current GRASS region.

- Keywords  
    This filter allows to use basic or advance keyword filtering. In the
    simple case user can define single keywords or multiple keywords
    with button "+". Logic operator between keywords is AND(&&). Second,
    advanced is based on OGC list of expressions which means that can be
    set filtr with logic relations between keywords or sets of keywords.
    Dialog for settings kewords text string is under "Advanced"
    checkbox. Syntax of constraints is based on python list syntax. Each
    keywords must be in braces \<'\> or \<"\>.

- - OR condition  
        a || b || c \["a","b","c"\]
  - AND condition  
        a && b && c \[\["a","b","c"\]\]
  - composition  
        (a && b) || c || d || e \[\["a","b"\],\["c"\],\["d"\],\["e"\]\]
        or \[\["a","b"\],"c","d","e"\]

### Browsing of metadata

In case of successful request, user can browse through results and show
request and response in xml format. If services contains uri of WMS, WFS
or WMS, module allows to add them directly with using upper toolbar.

## SEE ALSO

*[r.info](https://grass.osgeo.org/grass-stable/manuals/r.info.html),
[v.info.iso](v.info.iso.md), [g.gui.metadata](g.gui.metadata.md),
[db.csw.harvest](db.csw.harvest), [db.csw.admin](db.csw.admin),
[db.csw.run](db.csw.run)*

See also related [wiki
page](https://grasswiki.osgeo.org/wiki/ISO/INSPIRE_Metadata_Support).

## AUTHORS

Matej Krejci, [OSGeoREL](https://geo.fsv.cvut.cz/gwiki/osgeorel) at the
Czech Technical University in Prague, developed during [Google Summer of
Code 2015](https://trac.osgeo.org/grass/wiki/GSoC/2014/MetadataForGRASS)
(mentor: Martin Landa)

## SOURCE CODE

Available at: [g.gui.cswbrowser source code](https://github.com/OSGeo/grass-addons/tree/grass8/wxpython/wx.metadata/g.gui.cswbrowser)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/wxpython/wx.metadata/g.gui.cswbrowser))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
