---
name: g.proj.all.py
description: Reprojects raster and vector maps from given location and mapset to current mapset.
keywords: [ general, projection, transformation ]
---

# g.proj.all.py

Reprojects raster and vector maps from given location and mapset to current mapset.

=== "Command line"

    **g.proj.all.py**
    [**-rzo**]
    **location**=*name*
    **mapset**=*name*
    [**dbase**=*path*]
    [**method**=*string*]
    [**resolution**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.proj.all.py location=name mapset=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.proj.all.py***",
        **location**,
        **mapset**,
        **dbase**=*None*,
        **method**=*"nearest"*,
        **resolution**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.proj.all.py", location="name", mapset="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_proj_all_py*(**location**,
        **mapset**,
        **dbase**=*None*,
        **method**=*"nearest"*,
        **resolution**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_proj_all_py(location="name", mapset="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **location**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Location containing input raster map  
    **mapset**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset containing input raster map  
    **dbase**=*path*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to GRASS database of input location  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, linear, cubic, lanczos, linear_f, cubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**linear**: linear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**cubic**: cubic convolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**linear_f**: linear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**cubic_f**: cubic convolution with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    **resolution**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use current region instead of maps bounds  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume z coordinate is ellipsoidal height and transform if possible  
    &nbsp;&nbsp;&nbsp;&nbsp;3D vector maps only  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **location** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location containing input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset containing input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to GRASS database of input location  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, linear, cubic, lanczos, linear_f, cubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**linear**: linear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**cubic**: cubic convolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**linear_f**: linear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**cubic_f**: cubic convolution with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *z*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use current region instead of maps bounds  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume z coordinate is ellipsoidal height and transform if possible  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3D vector maps only  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **location** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Location containing input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **mapset** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset (default: current search path)  
    &nbsp;&nbsp;&nbsp;&nbsp;Mapset containing input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **dbase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to GRASS database of input location  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolation method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, linear, cubic, lanczos, linear_f, cubic_f, lanczos_f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: nearest neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**linear**: linear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**cubic**: cubic convolution  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos**: lanczos filter  
    &nbsp;&nbsp;&nbsp;&nbsp;**linear_f**: linear interpolation with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**cubic_f**: cubic convolution with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;**lanczos_f**: lanczos filter with fallback  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **resolution** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution of output raster map  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *z*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use current region instead of maps bounds  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume z coordinate is ellipsoidal height and transform if possible  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3D vector maps only  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.proj.all* reprojects all raster and vector maps from given location
and mapset to the current mapset. If flag `r` is set, current
computational region is used for raster maps reprojection. Otherwise,
each raster map is reprojected to its bounds, ignoring computational
region in the current mapset. Modules
[r.proj](https://grass.osgeo.org/grass-stable/manuals/r.proj.html) and
[v.proj](https://grass.osgeo.org/grass-stable/manuals/v.proj.html) are
used for reprojecting.

## EXAMPLE

This example reprojects raster maps (with resolution 50 map units) and
vector maps from mapset 'landsat' of 'nc\_spm\_08' location to the
current mapset.

```sh
g.proj.all resolution=50 location=nc_spm_08 mapset=landsat
```

## SEE ALSO

*[r.proj](https://grass.osgeo.org/grass-stable/manuals/r.proj.html),
[v.proj](https://grass.osgeo.org/grass-stable/manuals/v.proj.html)*

## AUTHORS

Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/),  
Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [g.proj.all source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.proj.all)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.proj.all))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
