---
name: i.eb.hsebal95
description: Performs sensible heat flux iteration (SEBAL 95).
keywords: [ imagery, heat flux, energy balance ]
---

# i.eb.hsebal95

Performs sensible heat flux iteration (SEBAL 95).

=== "Command line"

    **i.eb.hsebal95**
    [**-tacz**]
    **temperature**=*name*
    **elevation**=*name*
    **windvelocity2m**=*name*
    **ndvi**=*name*
    **albedo**=*name*
    **netradiation**=*name*
    **soilheatflux**=*name*
    [**iteration**=*integer*]
    [**row_wet**=*integer*]
    [**col_wet**=*integer*]
    [**row_dry**=*integer*]
    [**col_dry**=*integer*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.eb.hsebal95 temperature=name elevation=name windvelocity2m=name ndvi=name albedo=name netradiation=name soilheatflux=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.eb.hsebal95***",
        **temperature**,
        **elevation**,
        **windvelocity2m**,
        **ndvi**,
        **albedo**,
        **netradiation**,
        **soilheatflux**,
        **iteration**=*None*,
        **row_wet**=*None*,
        **col_wet**=*None*,
        **row_dry**=*None*,
        **col_dry**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.eb.hsebal95", temperature="name", elevation="name", windvelocity2m="name", ndvi="name", albedo="name", netradiation="name", soilheatflux="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_eb_hsebal95*(**temperature**,
        **elevation**,
        **windvelocity2m**,
        **ndvi**,
        **albedo**,
        **netradiation**,
        **soilheatflux**,
        **iteration**=*None*,
        **row_wet**=*None*,
        **col_wet**=*None*,
        **row_dry**=*None*,
        **col_dry**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_eb_hsebal95(temperature="name", elevation="name", windvelocity2m="name", ndvi="name", albedo="name", netradiation="name", soilheatflux="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Surface Skin Temperature input map [K]  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of dem input map [m a.s.l.]  
    **windvelocity2m**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Wind speed at 2m height input map [m/s]  
    **ndvi**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI input map [-]  
    **albedo**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Albedo input map [-]  
    **netradiation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous Net Solar Radiation input map [W/m2]  
    **soilheatflux**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous Soil Heat Flux input map [W/m2]  
    **iteration**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the number of SEBAL95 loops (default is 10)  
    **row_wet**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the wet pixel  
    **col_wet**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the wet pixel  
    **row_dry**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the dry pixel  
    **col_dry**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the dry pixel  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output sensible heat flux layer [W/m2]  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Temperature histogram check (careful!)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatic wet/dry pixel (careful!)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of manual dry/wet pixels are in image projection and not row/col  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;set negative evapo to zero  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Surface Skin Temperature input map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of dem input map [m a.s.l.]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **windvelocity2m** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Wind speed at 2m height input map [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI input map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Albedo input map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **netradiation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous Net Solar Radiation input map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilheatflux** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous Soil Heat Flux input map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **iteration** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the number of SEBAL95 loops (default is 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **row_wet** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the wet pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **col_wet** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the wet pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **row_dry** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the dry pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **col_dry** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the dry pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output sensible heat flux layer [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *a*, *c*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Temperature histogram check (careful!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatic wet/dry pixel (careful!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Coordinates of manual dry/wet pixels are in image projection and not row/col  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set negative evapo to zero  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Surface Skin Temperature input map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of dem input map [m a.s.l.]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **windvelocity2m** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Wind speed at 2m height input map [m/s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ndvi** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of NDVI input map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Albedo input map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **netradiation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous Net Solar Radiation input map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilheatflux** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of instantaneous Soil Heat Flux input map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **iteration** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of the number of SEBAL95 loops (default is 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **row_wet** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the wet pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **col_wet** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the wet pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **row_dry** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Row value of the dry pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **col_dry** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column value of the dry pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input,   
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output sensible heat flux layer [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *a*, *c*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Temperature histogram check (careful!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatic wet/dry pixel (careful!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Coordinates of manual dry/wet pixels are in image projection and not row/col  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;set negative evapo to zero  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.eb.h\_sebal95* computes the *sensible heat flux* \[W/m2\] after
Bastiaanssen, 1995 in \[1\].

*i.eb.h\_sebal95* given the vegetation height (hc), humidity (RU), wind
speed at two meters height (WS), temperature (T), digital terrain model
(DEM), and net radiation (NSR) raster input maps, calculates the
sensible heat flux map (h0).

Optionally the user can activate a flag (-z) that allows him setting to
zero all of the negative evapotranspiration cells; in fact these
negative values motivated by the condensation of the air water vapour
content, are sometime undesired because they can produce computational
problems. The usage of the flag -n detect that the module is run in
night hours and the appropriate soil heat flux is calculated.

The algorithm implements well known approaches: the hourly
Penman-Monteith method as presented in Allen et al. (1998) for land
surfaces and the Penman method (Penman, 1948) for water surfaces.  

Land and water surfaces are idenfyied by Vh:  
\- where Vh less than 0 vegetation is present and evapotranspiration is
calculated;  
\- where Vh=0 bare ground is present and evapotranspiration is
calculated;  
\- where Vh more than 0 water surface is present and evaporation is
calculated;  

For more details on the algorithms see \[1\].

### Parameters

- **DEM**=*name*  
    Input elevation raster \[m a.s.l.\]. Required.
- **T**=*name*  
    Input temperature raster \[°C\]. Required.
- **RH** =*name*  
    Input relative humidity raster \[%\]. Required.
- **WS** =*name*  
    Input wind speed at two meters raster \[m/s\]. Required.
- **NSR** =*name*  
    Input net solar radiation raster \[MJ/(m2\*h)\]. Required.
- **Vh** =*name*  
    Input vegetation heigth raster \[m\]. Required.
- **ETP** =*name*  
    Output evapotranspiration raster \[mm/h\]. Required.

## NOTES

Net solar radiation map in MJ/(m2\*h) can be computed from the
combination of the *r.sun*, run in mode 1, and the r.mapcalc commands.**

The sum of the three radiation components outputted by r.sun (beam,
diffuse, and reflected) multiplied by the Wh to Mj conversion factor
(0.0036) and optionally by a clear sky factor \[0-1\] allows the
generation of a map to be used as an NSR input for the *i.evapo.pm*
command.  
example:  
r.sun elev\_in=dem asp\_in=aspect slope\_in=slope lin=2 albedo=alb\_Mar
\\ incidout=out beam\_rad=beam diff\_rad=diffuse refl\_rad=reflected
day=73 time=13:00 dist=100;  
r.mapcalc 'NSR=0.0036\*(beam+diffuse+reflected)';

## SEE ALSO

*[i.eb.h\_iter](i.eb.h_iter.md), [i.eb.h0](i.eb.h0.md),
[i.evapo.pm](i.evapo.pm.md)*

## REFERENCES

\[1\] Bastiaanssen, W.G.M., 1995. Estimation of Land surface paramters
by remote sensing under clear-sky conditions. PhD thesis, Wageningen
University, Wageningen, The Netherlands.

\[2\] Allen, R.G., L.S. Pereira, D. Raes, and M. Smith. 1998. Crop
Evapotranspiration: Guidelines for computing crop water requirements.
Irrigation and Drainage Paper 56, Food and Agriculture Organization of
the United Nations, Rome, pp. 300

\[3\] Penman, H. L. 1948. Natural evaporation from open water, bare soil
and grass. Proc. Roy. Soc. London, A193, pp. 120-146.

## AUTHOR

Yann Chemin  
International Rice Research Institute, Los Banos, The Philippines.  
International Water management Institute, Colombo, Sri Lanka.

Contact: [Yann Chemin](mailto:y.chemin@cgiar.org)

## SOURCE CODE

Available at: [i.eb.hsebal95 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.eb.hsebal95)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.eb.hsebal95))  
Latest change: Friday Feb 21 12:27:42 2025 in commit [8fce680](https://github.com/OSGeo/grass-addons/commit/8fce680a2170ee81eff27fdf4315079b10a10f83)
