---
name: i.hyper.import.py
description: Hyperspectral imagery import.
keywords: [ imagery ]
---

# i.hyper.import.py

Hyperspectral imagery import.

=== "Command line"

    **i.hyper.import.py**
    [**-n**]
    **input**=*name*
    **product**=*string*
    **output**=*name*
    [**composites**=*string* [,*string*,...]]
    [**composites_custom**=*string*]
    [**strength**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.hyper.import.py input=name product=prisma output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.hyper.import.py***",
        **input**,
        **product**=*"prisma"*,
        **output**,
        **composites**=*None*,
        **composites_custom**=*None*,
        **strength**=*96*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.hyper.import.py", input="name", product="prisma", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_hyper_import_py*(**input**,
        **product**=*"prisma"*,
        **output**,
        **composites**=*None*,
        **composites_custom**=*None*,
        **strength**=*96*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_hyper_import_py(input="name", product="prisma", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the hyperspectral imagery: pick any file if the product is multi-file.  
    **product**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Define the hyperspectral product you want to import (lowercase).  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *prisma,  enmap,  tanager*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *prisma*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the name of the output hyperspectral 3D raster map.  
    **composites**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Composites to generate during import  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, cir, swir_agriculture, swir_geology*  
    **composites_custom**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Wavelenghts for custom composites  
    **strength**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cropping intensity - upper brightness level (0-100)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import also all-NULL bands  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the hyperspectral imagery: pick any file if the product is multi-file.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **product** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Define the hyperspectral product you want to import (lowercase).  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *prisma,  enmap,  tanager*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *prisma*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the name of the output hyperspectral 3D raster map.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **composites** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Composites to generate during import  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, cir, swir_agriculture, swir_geology*  
    **composites_custom** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Wavelenghts for custom composites  
    **strength** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cropping intensity - upper brightness level (0-100)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import also all-NULL bands  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the hyperspectral imagery: pick any file if the product is multi-file.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **product** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Define the hyperspectral product you want to import (lowercase).  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *prisma,  enmap,  tanager*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *prisma*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the name of the output hyperspectral 3D raster map.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **composites** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Composites to generate during import  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *rgb, cir, swir_agriculture, swir_geology*  
    **composites_custom** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Wavelenghts for custom composites  
    **strength** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cropping intensity - upper brightness level (0-100)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import also all-NULL bands  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.hyper.import* imports hyperspectral imagery into a 3D raster map
(`raster_3d`).

The module reads supported hyperspectral products and converts their
spectral bands into a single 3D raster map. The vertical (*z*) dimension
of the 3D raster represents the spectral dimension, where each cell
(*voxel*) contains the reflectance value for a specific spatial position
(*x, y*) and spectral band index.

*i.hyper.import* is part of the **i.hyper** module family designed for
hyperspectral data import, processing, and analysis in GRASS. It is
typically used in combination with
[i.hyper.preproc](i.hyper.preproc.html),
[i.hyper.explore](i.hyper.explore.html),
[i.hyper.composite](i.hyper.composite.html), and
[i.hyper.export](i.hyper.export.html).

The module currently supports the following hyperspectral products:

- **PRISMA** -- PRecursore IperSpettrale della Missione Applicativa
  (ASI)
- **EnMAP** -- Environmental Mapping and Analysis Program (DLR / GFZ)
- **Tanager** -- Planet Labs hyperspectral mission

During import, the appropriate product library from `i_hyper_lib` is
automatically loaded (for example, `enmap`, `prisma`, or `tanager`).
Metadata are parsed, bands are validated, and the resulting 3D raster
map is created with per-band metadata: **wavelength**, **FWHM**,
**valid**, and **unit**.

The metadata are used by other *i.hyper.\** modules, so data imported
with *i.hyper.import* or created with the same metadata structure are
fully compatible across the toolset.

The resulting `raster_3d` map can be analysed with standard GRASS 3D
raster tools (`r3.mapcalc`, `r3.stats`, `r3.univar`) or processed
further with the *i.hyper* suite of modules.

## NOTES

Imported 3D raster maps store hyperspectral reflectance or radiance
values (depending on the product). Bands containing only zeros, NULLs,
or invalid values are flagged with `valid: 0`; others are flagged as
`valid: 1`.

When the *composites* option is used, predefined or custom band
combinations are exported as 2D raster composites (e.g., RGB, CIR,
SWIR). All temporary rasters are automatically removed after import.

During import, *i.hyper.import* temporarily adjusts the computational
region to match the input data, ensuring consistent alignment between
imported bands. This region setting is temporary and restored at the end
of processing. The module does not perform any on-the-fly spatial or
spectral resampling. The imported cube retains the native resolution and
extent of the input product, but the region settings are not changed
during import.

## EXAMPLES

::: code

    # EnMAP example
    # Create a new GRASS project with EPSG:32633 (UTM Zone 33N)
    grass -c EPSG:32633 -e ~/grassdata/hyper_33N

    # Initialize and enter the new project (PERMANENT Mapset)
    grass ~/grassdata/hyper_33N/PERMANENT
:::

::: code

    # PRISMA L2D example
    i.hyper.import input=/data/PRISMA.he5 \
                   product=prisma \
                   output=prisma \
                   composites='rgb,cir,swir_agriculture,swir_geology'

    # Console output:
    Importing product: PRISMA
    Loading floating point  data with 4  bytes ...  (1254x1222x234)
    Created 3D raster map with all bands: prisma (234 bands).
    Generated composite raster: prisma_rgb
    Generated composite raster: prisma_cir
    Generated composite raster: prisma_swir_agriculture
    Generated composite raster: prisma_swir_geology
    (Fri Nov  5 13:12:00 2025) Command finished (1 min 23 sec)
:::

:::::::::: {align="center" style="margin: 10px"}
::: {align="center" style="margin: 10px"}
![PRISMA SWIR-geology composite example](import_example.jpg){width="600"
height="600" border="0"}\
*Figure: PRISMA SWIR-geology composite generated with i.hyper.import*\
[*Data source: PRISMA Product © Italian Space Agency (ASI), used under
ASI License to Use.*]{.small}
:::

::: code

    # Import an EnMAP L2A product and create RGB and CIR composites
    i.hyper.import input=/data/EnMAP_data_folder/ \
                   product=enmap \
                   output=enmap \
                   composites='cir,swir_agriculture'
                   composites_custom='650,1650,2200'
:::

::::::: {align="center" style="margin: 10px"}
::: {align="center" style="margin: 10px"}
![EnMAP SWIR-agriculture composite
example](import_example2.jpg){width="600" height="600" border="0"}\
*Figure: EnMAP SWIR-agriculture composite generated with
i.hyper.import*\
[*Data source: Copyright © 2012-2025 EnMAP at Earth Observation Center
EOC of DLR.*]{.small}
:::

::: code

    # Tanager example with a custom-defined composite
    # This one has radiance values
    i.hyper.import input=/data/Tanager.h5 \
                   product=tanager \
                   output=tanager \
                   composites='rgb' \
:::

:::: {align="center" style="margin: 10px"}
::: {align="center" style="margin: 10px"}
![Tanager-1 RGB composite example](import_example3.jpg){width="600"
height="600" border="0"}\
*Figure: Tanager-1 RGB composite generated with i.hyper.import*\
[*Data source: Planet Labs - Open Data, CC-BY-4.0.*]{.small}
:::

## SEE ALSO

[EnMAP Example Data
Products](https://www.enmap.org/data_tools/exampledata/), [Tanager Core
Imagery](https://www.planet.com/data/stac/browser/tanager-core-imagery/catalog.json),
[i.hyper.preproc](i.hyper.preproc.html),
[i.hyper.explore](i.hyper.explore.html),
[i.hyper.composite](i.hyper.composite.html),
[i.hyper.export](i.hyper.export.html)
[r3.support](https://grass.osgeo.org/grass-stable/manuals/r3.support.html),
[r3.stats](https://grass.osgeo.org/grass-stable/manuals/r3.stats.html)
[r3.stats](https://grass.osgeo.org/grass-stable/manuals/r3.univar.html)

## DEPENDENCIES

- **NumPy** -- Core numerical operations and array manipulation.
- **h5py** -- Interface for reading and writing `.h5` (HDF5)
  hyperspectral data products such as PRISMA and Tanager.
- **pyproj** -- Coordinate reference system and geospatial
  transformation library.

## AUTHORS

Alen Mangafić and Tomaž Žagar, Geodetic Institute of Slovenia
::::
:::::::
::::::::::

## SOURCE CODE

Available at: [i.hyper.import source code](https://github.com/OSGeo/grass-addons/tree/grass8/imagery/i.hyper/i.hyper.import)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/imagery/i.hyper/i.hyper.import))  
Latest change: Monday Nov 17 15:45:17 2025 in commit [615887d](https://github.com/OSGeo/grass-addons/commit/615887d217deac99a8f08bcf940384863fd47f2b)
