---
name: i.segment.uspo.py
description: Unsupervised segmentation parameter optimization
keywords: [ imagery, variance, segmentation, threshold, parallel ]
---

# i.segment.uspo.py

Unsupervised segmentation parameter optimization

=== "Command line"

    **i.segment.uspo.py**
    [**-kha**]
    **group**=*name*
    [**maps**=*name* [,*name*,...]]
    [**seeds**=*name*]
    [**output**=*name*]
    [**segment_map**=*name*]
    **regions**=*name* [,*name*,...]
    **segmentation_method**=*string*
    [**thresholds**=*float* [,*float*,...]]
    [**threshold_start**=*float*]
    [**threshold_stop**=*float*]
    [**threshold_step**=*float*]
    [**minsizes**=*integer* [,*integer*,...]]
    [**minsize_start**=*integer*]
    [**minsize_stop**=*integer*]
    [**minsize_step**=*integer*]
    [**radiuses**=*float* [,*float*,...]]
    [**radius_start**=*float*]
    [**radius_stop**=*float*]
    [**radius_step**=*float*]
    [**hrs**=*float* [,*float*,...]]
    [**hr_start**=*float*]
    [**hr_stop**=*float*]
    [**hr_step**=*float*]
    [**autocorrelation_indicator**=*string*]
    [**optimization_function**=*string*]
    [**f_function_alpha**=*float*]
    [**number_best**=*integer*]
    [**memory**=*integer*]
    [**processes**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.segment.uspo.py group=name regions=name segmentation_method=region_growing thresholds=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.segment.uspo.py***",
        **group**,
        **maps**=*None*,
        **seeds**=*None*,
        **output**=*None*,
        **segment_map**=*None*,
        **regions**,
        **segmentation_method**=*"region_growing"*,
        **thresholds**=*None*,
        **threshold_start**=*None*,
        **threshold_stop**=*None*,
        **threshold_step**=*None*,
        **minsizes**=*None*,
        **minsize_start**=*None*,
        **minsize_stop**=*None*,
        **minsize_step**=*None*,
        **radiuses**=*None*,
        **radius_start**=*None*,
        **radius_stop**=*None*,
        **radius_step**=*None*,
        **hrs**=*None*,
        **hr_start**=*None*,
        **hr_stop**=*None*,
        **hr_step**=*None*,
        **autocorrelation_indicator**=*"morans"*,
        **optimization_function**=*"sum"*,
        **f_function_alpha**=*1*,
        **number_best**=*1*,
        **memory**=*300*,
        **processes**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.segment.uspo.py", group="name", regions="name", segmentation_method="region_growing", thresholds=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_segment_uspo_py*(**group**,
        **maps**=*None*,
        **seeds**=*None*,
        **output**=*None*,
        **segment_map**=*None*,
        **regions**,
        **segmentation_method**=*"region_growing"*,
        **thresholds**=*None*,
        **threshold_start**=*None*,
        **threshold_stop**=*None*,
        **threshold_step**=*None*,
        **minsizes**=*None*,
        **minsize_start**=*None*,
        **minsize_stop**=*None*,
        **minsize_step**=*None*,
        **radiuses**=*None*,
        **radius_start**=*None*,
        **radius_stop**=*None*,
        **radius_step**=*None*,
        **hrs**=*None*,
        **hr_start**=*None*,
        **hr_stop**=*None*,
        **hr_step**=*None*,
        **autocorrelation_indicator**=*"morans"*,
        **optimization_function**=*"sum"*,
        **f_function_alpha**=*1*,
        **number_best**=*1*,
        **memory**=*300*,
        **processes**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_segment_uspo_py(group="name", regions="name", segmentation_method="region_growing", thresholds=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Group to use for segmentation  
    **maps**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster band(s) for  which to calculate variance (default: all group members)  
    **seeds**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seeds for segmentation  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (- for standard output)  
    **segment_map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for "best" output segmentation map per region  
    **regions**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Regions in which to analyze the variance  
    **segmentation_method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Segmentation method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *region_growing, mean_shift*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *region_growing*  
    **thresholds**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Thresholds to test  
    **threshold_start**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest threshold to test  
    **threshold_stop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold at which to stop (not included)  
    **threshold_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between thresholds  
    **minsizes**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in a segment to test  
    **minsize_start**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest minimum segment size to test  
    **minsize_stop**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for minimum segment size at which to stop (not included)  
    **minsize_step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between minimum segment sizes  
    **radiuses**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Radiuses to test  
    **radius_start**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest radius to test  
    **radius_stop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius at which to stop (not included)  
    **radius_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between radiuses  
    **hrs**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Spectral bandwidths to test  
    **hr_start**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest spectral bandwith to test  
    **hr_stop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spectral bandwith at which to stop (not included)  
    **hr_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between spectral bandwidths  
    **autocorrelation_indicator**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Indicator for measuring inter-segment heterogeneity  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *morans, geary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *morans*  
    **optimization_function**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimization function used to determine "best" parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sum*  
    **f_function_alpha**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alpha value used for F-measure optimization function  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **number_best**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of desired best parameter values and maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total memory (in MB) to allocate (will be divided by processes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **processes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep all segmented maps  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use hierarchical segmentation  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use adaptive spectral bandwidth (with mean shift)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Group to use for segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **maps** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster band(s) for  which to calculate variance (default: all group members)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **seeds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seeds for segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (- for standard output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **segment_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for "best" output segmentation map per region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **regions** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regions in which to analyze the variance  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **segmentation_method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segmentation method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *region_growing, mean_shift*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *region_growing*  
    **thresholds** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thresholds to test  
    **threshold_start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest threshold to test  
    **threshold_stop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold at which to stop (not included)  
    **threshold_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between thresholds  
    **minsizes** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in a segment to test  
    **minsize_start** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest minimum segment size to test  
    **minsize_stop** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for minimum segment size at which to stop (not included)  
    **minsize_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between minimum segment sizes  
    **radiuses** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radiuses to test  
    **radius_start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest radius to test  
    **radius_stop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius at which to stop (not included)  
    **radius_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between radiuses  
    **hrs** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spectral bandwidths to test  
    **hr_start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest spectral bandwith to test  
    **hr_stop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spectral bandwith at which to stop (not included)  
    **hr_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between spectral bandwidths  
    **autocorrelation_indicator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Indicator for measuring inter-segment heterogeneity  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *morans, geary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *morans*  
    **optimization_function** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimization function used to determine "best" parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sum*  
    **f_function_alpha** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alpha value used for F-measure optimization function  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **number_best** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of desired best parameter values and maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total memory (in MB) to allocate (will be divided by processes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *h*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep all segmented maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use hierarchical segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use adaptive spectral bandwidth (with mean shift)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Group to use for segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **maps** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster band(s) for  which to calculate variance (default: all group members)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **seeds** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seeds for segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (- for standard output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **segment_map** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for "best" output segmentation map per region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **regions** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Regions in which to analyze the variance  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **segmentation_method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segmentation method to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *region_growing, mean_shift*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *region_growing*  
    **thresholds** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Thresholds to test  
    **threshold_start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest threshold to test  
    **threshold_stop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold at which to stop (not included)  
    **threshold_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between thresholds  
    **minsizes** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in a segment to test  
    **minsize_start** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest minimum segment size to test  
    **minsize_stop** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value for minimum segment size at which to stop (not included)  
    **minsize_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between minimum segment sizes  
    **radiuses** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radiuses to test  
    **radius_start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest radius to test  
    **radius_stop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius at which to stop (not included)  
    **radius_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between radiuses  
    **hrs** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spectral bandwidths to test  
    **hr_start** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lowest spectral bandwith to test  
    **hr_stop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spectral bandwith at which to stop (not included)  
    **hr_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Step to use between spectral bandwidths  
    **autocorrelation_indicator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Indicator for measuring inter-segment heterogeneity  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *morans, geary*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *morans*  
    **optimization_function** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optimization function used to determine "best" parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, f*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sum*  
    **f_function_alpha** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Alpha value used for F-measure optimization function  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **number_best** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of desired best parameter values and maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total memory (in MB) to allocate (will be divided by processes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*, *h*, *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep all segmented maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use hierarchical segmentation  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use adaptive spectral bandwidth (with mean shift)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.segment.uspo* provides unsupervised segmentation parameter
optimization for
*[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html)*
determined by the compromise between intra-segment variance and
inter-segment spatial autocorrelation.

The module runs segmentation across a user defined set of thresholds and
minimum segment sizes, as well, for the mean shift algorithm, a set of
spectral and spatial bandwiths. For the mean shift algorithm, you can
also activate adaptive bandwidth using the *-a* flag.

The user provides an imagery **group** and the name of an **output**
text file where parameter and optimization values for all tested
segmentations are stored. The user can either give a list of thresholds
and minimum sizes, or provides start, stop and step values for each. In
addition, the user can provide a list of named **regions** for which to
test the segmentation. This allows to not test the entire image, but
rather to test specific areas in the image that might be characterstic
for specific types of land cover.

The module then selects the parameters providing the highest values of a
given optimization function. The number of "best" parameter combinations
to provide to the user per **region** is defined by **number\_best**.

Two optimization functions are available via the
**optimization\_function** parameter: A simple sum of the normalized
criteria values as defined by Espindola et al (2006), or the F-function
as defined by Johnson et al (2015). When using the F-function, the user
can determine the **f\_function\_alpha** value which determines the
relative weight of the intra-segment variance as compared to the
inter-segment spatial autocorrelation. A value of 0.5 gives the former
half weight of the latter, A value of 2 gives the former double weight
than the latter.

The optimization functions use intra-segment variance and inter-segment
spatial autocorrelation. For the latter, the user can chose to use
either [Moran's I](https://en.wikipedia.org/wiki/Moran%27s_I) or
[Geary's C](https://en.wikipedia.org/wiki/Geary%27s_C).

The user can chose between non-hierarchical (default) and hierarchical
segmentation using the **h** flag. The latter uses each segmentation at
a given threshold level as seed for the segmentation at the next
threshold level within a given minimum segment size. Note that this
leads to less optimal parallelization as for a given minsize, all
segmentations have to be done sequentially (see below).

The **segment\_map** parameter allows to provide a basename for keeping
the **number\_best** best segmentations for each given **region**
according to the optimization function. The resulting map names will be
a combination of this basename, the region, the threshold, the minsize
and the rank of the map within the region according to its optimization
criteria value.

The module uses high-level parallelization (running different
segmentations in parallel and then running the collection of parameter
values in parallel). The parameter **processes** allows to define how
many processes should be run in parallel. Note that when using
hierarchical segmentation the number of parallel processes is limited to
the number of different mininum segment sizes to test.

The **k** flag allows to keep all segmentation maps created during the
process.

## NOTES

The module depends on the addon
[r.neighborhoodmatrix](https://grass.osgeo.org/grass-stable/manuals/addons/r.neighborhoodmatrix.html)
which needs to be installed.

Any unsupervised optimization can at best be a support to the user.
Visual and other types of validation of the results, possibly comparing
several of the "best" solutions, remain necessary.

Even though the module allows the user to test different *minsizes*, it
is probably better to run the module with minsizes=1 and then adapt the
minsize in the final run of
[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html)
depending on the desired minimum mapping unit.

In hierarchical segmentation mode, each segmentation is used as seed for
the next hierarchical level. This means that these segmentations have to
be run sequentially. Currently, parallelization is thus only used if
more than one value was given for *minsize*. In a future version,
parallelization should optionally be run by region if the number of
regions is larger than the number of different *minsize* values.

## EXAMPLE

```sh
g.region -au n=220767 s=220392 w=638129 e=638501 res=1 save=region1
g.region -au n=222063 s=221667 w=637659 e=638058 res=1 save=region2
i.group ortho input=ortho_2001_t792_1m
i.segment.uspo group=ortho regions=region1,region2 \
    output=ortho_parameters.csv segment_map=ortho_uspo \
    threshold_start=0.02 threshold_stop=0.21 threshold_step=0.02 \
    minsizes=5,10,15 number_best=5 processes=4 memory=4000
```

## REFERENCES

G. M. Espindola , G. Camara , I. A. Reis , L. S. Bins , A. M. Monteiroi
(2006), Parameter selection for region-growing image segmentation
algorithms using spatial autocorrelation, International Journal of
Remote Sensing, Vol. 27, Iss. 14, pp. 3035-3040,
<https://doi.org/10.1080/01431160600617194>  
  
B. A. Johnson, M. Bragais, I. Endo, D. B. Magcale-Macandog, P. B. M.
Macandog (2015), Image Segmentation Parameter Optimization Considering
Within- and Between-Segment Heterogeneity at Multiple Scale Levels: Test
Case for Mapping Residential Areas Using Landsat Imagery, ISPRS
International Journal of Geo-Information, 4(4), pp. 2292-2305,
<https://doi.org/10.3390/ijgi4042292>

## SEE ALSO

*[i.segment](https://grass.osgeo.org/grass-stable/manuals/i.segment.html),
[i.group](https://grass.osgeo.org/grass-stable/manuals/i.group.html),
[i.segment.hierarchical](i.segment.hierarchical.md),
[r.neighborhoodmatrix](r.neighborhoodmatrix.md)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [i.segment.uspo source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.segment.uspo)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.segment.uspo))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
