---
name: i.signature.copy.py
description: Copies signature file from a group/subgroup to another group/subgroup.
keywords: [ imagery, map management, copy, signature, group ]
---

# i.signature.copy.py

Copies signature file from a group/subgroup to another group/subgroup.

=== "Command line"

    **i.signature.copy.py**
    **igroup**=*name*
    **isubgroup**=*name*
    **isignature**=*string*
    **ogroup**=*string*
    **osubgroup**=*string*
    [**osignature**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.signature.copy.py igroup=name isubgroup=name isignature=string ogroup=string osubgroup=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.signature.copy.py***",
        **igroup**,
        **isubgroup**,
        **isignature**,
        **ogroup**,
        **osubgroup**,
        **osignature**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.signature.copy.py", igroup="name", isubgroup="name", isignature="string", ogroup="string", osubgroup="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_signature_copy_py*(**igroup**,
        **isubgroup**,
        **isignature**,
        **ogroup**,
        **osubgroup**,
        **osignature**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_signature_copy_py(igroup="name", isubgroup="name", isignature="string", ogroup="string", osubgroup="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **igroup**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input group for signature file to copy  
    **isubgroup**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input subgroup for signature file to copy  
    **isignature**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the input signature file to copy  
    **ogroup**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output group where copy the signature file  
    **osubgroup**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output subgroup where copy the signature file  
    **osignature**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output signature file  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **igroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input group for signature file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **isubgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input subgroup for signature file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **isignature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the input signature file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile  
    **ogroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output group where copy the signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group  
    **osubgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output subgroup where copy the signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup  
    **osignature** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output signature file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **igroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input group for signature file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **isubgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input subgroup for signature file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **isignature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the input signature file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile  
    **ogroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output group where copy the signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group  
    **osubgroup** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output subgroup where copy the signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup  
    **osignature** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;The name of the output signature file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.signature.copy* copies a signature file from a group/subgroup to
another group/subgroup.

## EXAMPLE

```sh
i.signature.copy igroup=name isubgroup=subname isignature=test ogroup=name2 osubgroup=subname2
```

## AUTHOR

Luca Delucchi

## SOURCE CODE

Available at: [i.signature.copy source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.signature.copy)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.signature.copy))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
