---
name: i.wavelet
description: Decompostion/Recomposition in temporal dimension using wavelets
keywords: [ imagery, wavelet, fusion ]
---

# i.wavelet

Decompostion/Recomposition in temporal dimension using wavelets

=== "Command line"

    **i.wavelet**
    [**-iHD**]
    [**input_group_to_decompose**=*name*]
    [**output_lp1_from_decomposition**=*name*]
    [**output_lp2_from_decomposition**=*name*]
    [**output_hp1_from_decomposition**=*name*]
    [**output_hp2_from_decomposition**=*name*]
    [**input_lp2_group_for_recomposition**=*name*]
    [**input_hp1_group_for_recomposition**=*name*]
    [**input_hp2_group_for_recomposition**=*name*]
    [**output_from_recomposition**=*name*]
    [**wavelet_sample_rate**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.wavelet
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.wavelet***",
        **input_group_to_decompose**=*None*,
        **output_lp1_from_decomposition**=*None*,
        **output_lp2_from_decomposition**=*None*,
        **output_hp1_from_decomposition**=*None*,
        **output_hp2_from_decomposition**=*None*,
        **input_lp2_group_for_recomposition**=*None*,
        **input_hp1_group_for_recomposition**=*None*,
        **input_hp2_group_for_recomposition**=*None*,
        **output_from_recomposition**=*None*,
        **wavelet_sample_rate**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.wavelet")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_wavelet*(**input_group_to_decompose**=*None*,
        **output_lp1_from_decomposition**=*None*,
        **output_lp2_from_decomposition**=*None*,
        **output_hp1_from_decomposition**=*None*,
        **output_hp2_from_decomposition**=*None*,
        **input_lp2_group_for_recomposition**=*None*,
        **input_hp1_group_for_recomposition**=*None*,
        **input_hp2_group_for_recomposition**=*None*,
        **output_from_recomposition**=*None*,
        **wavelet_sample_rate**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_wavelet()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input_group_to_decompose**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **output_lp1_from_decomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **output_lp2_from_decomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **output_hp1_from_decomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **output_hp2_from_decomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **input_lp2_group_for_recomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **input_hp1_group_for_recomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **input_hp2_group_for_recomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **output_from_recomposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **wavelet_sample_rate**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;4,6,8,10,12,14,16,18,20  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Recomposition (Default: Decomposition)  
    **-H**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use Haar wavelets  
    **-D**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use Daubechies wavelets (specify resolution=4,6,8,10,12,14,16,18,20  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input_group_to_decompose** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output_lp1_from_decomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_lp2_from_decomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_hp1_from_decomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_hp2_from_decomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **input_lp2_group_for_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **input_hp1_group_for_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **input_hp2_group_for_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output_from_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **wavelet_sample_rate** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;4,6,8,10,12,14,16,18,20  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *H*, *D*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recomposition (Default: Decomposition)  
    &nbsp;&nbsp;&nbsp;&nbsp;**H**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Haar wavelets  
    &nbsp;&nbsp;&nbsp;&nbsp;**D**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Daubechies wavelets (specify resolution=4,6,8,10,12,14,16,18,20  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input_group_to_decompose** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output_lp1_from_decomposition** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_lp2_from_decomposition** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_hp1_from_decomposition** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_hp2_from_decomposition** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **input_lp2_group_for_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **input_hp1_group_for_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **input_hp2_group_for_recomposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **output_from_recomposition** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **wavelet_sample_rate** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;4,6,8,10,12,14,16,18,20  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *integer*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *H*, *D*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recomposition (Default: Decomposition)  
    &nbsp;&nbsp;&nbsp;&nbsp;**H**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Haar wavelets  
    &nbsp;&nbsp;&nbsp;&nbsp;**D**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use Daubechies wavelets (specify resolution=4,6,8,10,12,14,16,18,20  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.wavelet* Decomposes the time-series with the requested wavelet. The
output will have 4 components, High-Pass Level 1 and 2, Low-Pass Level 1
and 2. Low Pass Level 1 can be recomposed using HP2 and LP2 using the
recomposition mode.  
This module is designed to make a temporal fusion from multi-sources.

## NOTES

## TODO

More wavelet families to be included.

## SEE ALSO

*[r.hants](r.hants.md), [i.lmf](i.lmf.md)*

## AUTHOR

Yann Chemin, International Water Management Institute

## SOURCE CODE

Available at: [i.wavelet source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/imagery/i.wavelet)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/imagery/i.wavelet))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
