---
name: r.agent.rand.py
description: Agents wander around on the terrain, marking paths to new locations.
keywords: [  ]
---

# r.agent.rand.py

Agents wander around on the terrain, marking paths to new locations.

=== "Command line"

    **r.agent.rand.py**
    [**-p**]
    **outputmap**=*string*
    **costmap**=*string*
    **rounds**=*integer*
    [**mark**=*integer*]
    [**maxagents**=*integer*]
    [**agentslife**=*integer*]
    [**agentfreedom**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.agent.rand.py outputmap=string costmap=string rounds=999
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.agent.rand.py***",
        **outputmap**,
        **costmap**,
        **rounds**=*999*,
        **mark**=*None*,
        **maxagents**=*None*,
        **agentslife**=*None*,
        **agentfreedom**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.agent.rand.py", outputmap="string", costmap="string", rounds=999)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_agent_rand_py*(**outputmap**,
        **costmap**,
        **rounds**=*999*,
        **mark**=*None*,
        **maxagents**=*None*,
        **agentslife**=*None*,
        **agentfreedom**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_agent_rand_py(outputmap="string", costmap="string", rounds=999)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **outputmap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of step output map  
    **costmap**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of penalty resp. cost raster map (note conversion checkbox)  
    **rounds**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of iterations/rounds to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *999*  
    **mark**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mark each step an agent takes  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **maxagents**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum amount of agents that may live concurrently (x\*y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<the bigger the playground,  the more space they have>*  
    **agentslife**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time to live for an agent  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **agentfreedom**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of possible directions the ant can take (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow overwriting existing output maps  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **outputmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of step output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **costmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of penalty resp. cost raster map (note conversion checkbox)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **rounds** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of iterations/rounds to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Ph  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *999*  
    **mark** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mark each step an agent takes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Ph  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **maxagents** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum amount of agents that may live concurrently (x\*y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Ph  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<the bigger the playground,  the more space they have>*  
    **agentslife** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time to live for an agent  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: g
5  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **agentfreedom** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of possible directions the ant can take (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: x5  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow overwriting existing output maps  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **outputmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of step output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **costmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of penalty resp. cost raster map (note conversion checkbox)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **rounds** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of iterations/rounds to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Ph  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-999999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *999*  
    **mark** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mark each step an agent takes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Ph  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **maxagents** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum amount of agents that may live concurrently (x\*y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: Ph  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<the bigger the playground,  the more space they have>*  
    **agentslife** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time to live for an agent  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: g
5  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-<max integer on system would make sense>*  
    **agentfreedom** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of possible directions the ant can take (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: x5  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Allow overwriting existing output maps  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This submodule - *r.agent.rand* - is nothing but an example of how the
*libagent* library might be used to get a simple setup running.

## NOTES

As the name suggests, *r.agent.rand* lets agents wander around just
based on chance. You only need to define a single input map, just some
raster map, that will be completely ignored, it is only used to set the
frame for the agents to come.

## SEE ALSO

## AUTHOR

Michael Lustenberger inofix.ch

## SOURCE CODE

Available at: [r.agent.rand source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.agent/r.agent.rand)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.agent/r.agent.rand))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
