---
name: r.bitpattern
description: Compares bit patterns with a raster map.
keywords: [ raster, algebra ]
---

# r.bitpattern

Compares bit patterns with a raster map.

=== "Command line"

    **r.bitpattern**
    **input**=*name*
    **output**=*name*
    **pattern**=*integer*
    **patval**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.bitpattern input=name output=name pattern=0 patval=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.bitpattern***",
        **input**,
        **output**,
        **pattern**,
        **patval**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.bitpattern", input="name", output="name", pattern=0, patval=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_bitpattern*(**input**,
        **output**,
        **pattern**,
        **patval**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_bitpattern(input="name", output="name", pattern=0, patval=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **pattern**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bit pattern position(s)  
    **patval**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bit pattern value  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **pattern** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bit pattern position(s)  
    **patval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bit pattern value  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **pattern** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bit pattern position(s)  
    **patval** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bit pattern value  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.bitpattern* performs bit pattern comparisons. The module can be used
to pixelwise verify a satellite image for low quality pixels if a
Quality Control Bit Index map is provided (e.g. as for MODIS sensor
maps). The functionality is two-fold:

1. define position: set bit(s) to 1 which shall match, then convert
    this position pattern to integer, set pattern= parameter with that
    integer value
2. define pattern \*value\* which should be in that position: first bit
    pattern of value, convert to integer, set patval= parameter

If several bitpatterns have to be tested, the resulting maps can be used
to exclude low quality pixels in the input satellite image using
*r.mapcalc* (OR and NOT operators).

## EXAMPLE

1. Define position:

    ```text
        xx xx 1x xx
        binary: 1000 -> integer: 8 -> pattern=8
    ```

2. Define value:

    ```text
        Ex.: We want to check for 0 in that position
        xx xx 0x xx
        binary: 0000 -> integer: 0 -> patval=0
        If value can be arbitrary (0/1), then assume 0 value
    ```

## SEE ALSO

*[i.modis.qc](https://grass.osgeo.org/grass-stable/manuals/i.modis.qc.html),
[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html)*

## AUTHORS

Radim Blazek, Markus Neteler

## SOURCE CODE

Available at: [r.bitpattern source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.bitpattern)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.bitpattern))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
