---
name: r.diversity.py
description: Calculate diversity indices based on a moving window using r.li packages
keywords: [ raster ]
---

# r.diversity.py

Calculate diversity indices based on a moving window using r.li packages

=== "Command line"

    **r.diversity.py**
    [**-t**]
    **input**=*name*
    **prefix**=*name*
    [**alpha**=*alpha value for Renyi entropy* [,*alpha value for Renyi entropy*,...]]
    [**size**=*moving window* [,*moving window*,...]]
    [**method**=*method* [,*method*,...]]
    [**exclude**=*exclude method* [,*exclude method*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.diversity.py input=name prefix=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.diversity.py***",
        **input**,
        **prefix**,
        **alpha**=*None*,
        **size**=*3*,
        **method**=*"simpson,shannon,pielou,renyi"*,
        **exclude**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.diversity.py", input="name", prefix="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_diversity_py*(**input**,
        **prefix**,
        **alpha**=*None*,
        **size**=*3*,
        **method**=*"simpson,shannon,pielou,renyi"*,
        **exclude**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_diversity_py(input="name", prefix="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **prefix**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster map(s)  
    **alpha**=*alpha value for Renyi entropy* [,*alpha value for Renyi entropy*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Order of generalized entropy (&gt; 0.0; undefined for 1.0)  
    **size**=*moving window* [,*moving window*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of processing window (odd number only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method**=*method* [,*method*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *simpson, shannon, pielou, renyi*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *simpson,shannon,pielou,renyi*  
    **exclude**=*exclude method* [,*exclude method*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Exclude methods  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *simpson, shannon, pielou, renyi*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve configuration files  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **alpha** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Order of generalized entropy (&gt; 0.0; undefined for 1.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *alpha value for Renyi entropy*  
    **size** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of processing window (odd number only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *moving window*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *simpson, shannon, pielou, renyi*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *simpson,shannon,pielou,renyi*  
    **exclude** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exclude methods  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *exclude method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *simpson, shannon, pielou, renyi*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Preserve configuration files  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **prefix** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **alpha** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Order of generalized entropy (&gt; 0.0; undefined for 1.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *alpha value for Renyi entropy*  
    **size** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of processing window (odd number only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *moving window*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of methods to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *simpson, shannon, pielou, renyi*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *simpson,shannon,pielou,renyi*  
    **exclude** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exclude methods  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *exclude method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *simpson, shannon, pielou, renyi*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Preserve configuration files  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.diversity* calculates selected diversity indices by calling various
*r.li* commands.

This script uses the Pielou, Renyi, Shannon and Simpson indices. The
output is a map for each index.

## NOTES

The user does not need to create a "conf" file with *r.li.setup* because
this file will be created automatically by the script.  
In **size** option it is possible use more values: the user can set more
values with comma (,) and a range with minus (-).  
If you calculate Renyi entropy remember to add the **alpha** option.
Alpha option support single and multi values but not a range.  
If the input raster contains NULL value cells, *r.diversity* returns -1
for these cells.  
If the user wants to keep NULL values instead, run subsequently on the
resulting map:  

```sh
r.null map=my_map setnull=-1
```

## EXAMPLES

To calculate the set of indices from a NDVI map, with a moving window of
3 x 3 pixel, run:

```sh
r.diversity input=ndvi_map prefix=diversity alpha=0.5
```

To calculate the set of indices from a NDVI map, with a moving window of
7 x 7 pixel, run:

```sh
r.diversity input=ndvi_map prefix=diversity alpha=0.5 size=7
```

To calculate only Pielou and Simpson indices from a NDVI map, with
several moving window (3 x 3, 5 x 5, 7 x 7, 9 x 9), run:

```sh
r.diversity input=ndvi_map prefix=diversity size=3-9 method=pielou,simpson
```

To calculate all methods excluding Pielou from a NDVI map, with two
moving window (3 x 3, 9 x 9), run:

```sh
r.diversity input=ndvi_map prefix=diversity size=3,9 exclude=pielou alpha=3
```

## SEE ALSO

*[r.li](https://grass.osgeo.org/grass-stable/manuals/r.li.html),
[r.li.pielou](https://grass.osgeo.org/grass-stable/manuals/r.li.pielou.html),
[r.li.renyi](https://grass.osgeo.org/grass-stable/manuals/r.li.renyi.html),
[r.li.shannon](https://grass.osgeo.org/grass-stable/manuals/r.li.shannon.html),
[r.li.simpson](https://grass.osgeo.org/grass-stable/manuals/r.li.simpson.html)*

## AUTHORS

Luca Delucchi and Duccio Rocchini, Fondazione E. Mach (Italy)

## SOURCE CODE

Available at: [r.diversity source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.diversity)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.diversity))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
