---
name: r.fidimo.py
description: Calculating fish dispersal in a river network from source populations with species specific dispersal parameters
keywords: [ Fish Dispersal Model ]
---

# r.fidimo.py

Calculating fish dispersal in a river network from source populations with species specific dispersal parameters

=== "Command line"

    **r.fidimo.py**
    [**-bar**]
    [**river**=*string*]
    [**coors**=*x,y*]
    [**barriers**=*string*]
    [**passability_col**=*name*]
    [**n_source**=*number[%]*]
    [**source_populations**=*string*]
    [**species**=*string*]
    [**l**=*integer*]
    [**ar**=*float*]
    [**t**=*integer*]
    [**p**=*float*]
    [**habitat_attract**=*string*]
    [**habitat_p**=*string*]
    [**truncation**=*string*]
    [**seed1**=*integer*]
    [**seed2**=*integer*]
    [**output**=*name*]
    [**statistical_interval**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.fidimo.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.fidimo.py***",
        **river**=*None*,
        **coors**=*None*,
        **barriers**=*None*,
        **passability_col**=*None*,
        **n_source**=*None*,
        **source_populations**=*None*,
        **species**=*None*,
        **l**=*None*,
        **ar**=*None*,
        **t**=*30*,
        **p**=*0.67*,
        **habitat_attract**=*None*,
        **habitat_p**=*None*,
        **truncation**=*"0.99"*,
        **seed1**=*None*,
        **seed2**=*None*,
        **output**=*"fidimo_out"*,
        **statistical_interval**=*"no"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.fidimo.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_fidimo_py*(**river**=*None*,
        **coors**=*None*,
        **barriers**=*None*,
        **passability_col**=*None*,
        **n_source**=*None*,
        **source_populations**=*None*,
        **species**=*None*,
        **l**=*None*,
        **ar**=*None*,
        **t**=*30*,
        **p**=*0.67*,
        **habitat_attract**=*None*,
        **habitat_p**=*None*,
        **truncation**=*"0.99"*,
        **seed1**=*None*,
        **seed2**=*None*,
        **output**=*"fidimo_out"*,
        **statistical_interval**=*"no"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_fidimo_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **river**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;River network (raster, e.g. output from r.watershed)  
    **coors**=*x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;River networks' outlet coordinates: E,N  
    **barriers**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Barrier point file (vector map)  
    **passability_col**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name indicating passability value (0-1) of barrier  
    **n_source**=*number[%]*  
    &nbsp;&nbsp;&nbsp;&nbsp;Either: Number of random cells with source populations  
    **source_populations**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Or: Source population raster (relative or absolute occurrence)  
    **species**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select fish species  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Custom species, Catostomus commersoni, Moxostoma duquesnii, Moxostoma erythrurum, Ambloplites rupestris, Lepomis auritus, Lepomis cyanellus, Lepomis macrochirus, Lepomis megalotis, Micropterus dolomieui, Micropterus punctulatus, Micropterus salmoides, Pomoxis annularis, Cottus bairdii, Cottus gobio, Abramis brama, Barbus barbus, Cyprinus carpio carpio, Gobio gobio, Leuciscus idus, Rutilus rutilus, Squalius cephalus, Tinca tinca, Esox lucius, Fundulus heteroclitus heteroclitus, Ameiurus natalis, Ictalurus punctatus, Morone americana, Etheostoma flabellare, Etheostoma nigrum, Perca fluviatilis, Percina nigrofasciata, Sander lucioperca, Oncorhynchus mykiss,  Oncorhynchus gilae, Salmo salar, Salmo trutta fario, Salvelinus fontinalis, Salvelinus malma malma, Thymallus thymallus, Aplodinotus grunniens, Salmo trutta, Gobio gobio, Rutilus rutilus*  
    **l**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fish Length [mm] (If no species is given, range=39-810)  
    **ar**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect Ratio of Caudal Fin (If no species is given) (valid range 0.51 - 2.29)  
    **t**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time interval for model step [d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3650*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **p**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Share of the stationary component (valid range 0 - 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.67*  
    **habitat_attract**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractiveness of habitat used as weighting factor (sink effect, habitat-dependent dispersal)  
    **habitat_p**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spatially varying and habitat-dependent p factor (float: 0-1, source effect, habitat-dependent dispersal)  
    **truncation**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;kernel truncation criterion (precision)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.9, 0.95, 0.99, 0.995, 0.999, 0.99999, 0.999999999, inf*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.99*  
    **seed1**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for generating dispersal parameters  
    **seed2**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for multinomial realisation step  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fidimo_out*  
    **statistical_interval**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical Intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, Confidence Interval, Prediction Interval, Random Value within Confidence Interval*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *no*  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Don't keep basic vector maps (source_points, barriers)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep all temporal vector and raster maps  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Source population input are real fish counts per cell. Backtransformation into fish counts will be performed.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **river** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;River network (raster, e.g. output from r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **coors** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;River networks' outlet coordinates: E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **barriers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Barrier point file (vector map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector  
    **passability_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name indicating passability value (0-1) of barrier  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **n_source** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Either: Number of random cells with source populations  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *number[%]*  
    **source_populations** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Or: Source population raster (relative or absolute occurrence)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **species** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select fish species  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Custom species, Catostomus commersoni, Moxostoma duquesnii, Moxostoma erythrurum, Ambloplites rupestris, Lepomis auritus, Lepomis cyanellus, Lepomis macrochirus, Lepomis megalotis, Micropterus dolomieui, Micropterus punctulatus, Micropterus salmoides, Pomoxis annularis, Cottus bairdii, Cottus gobio, Abramis brama, Barbus barbus, Cyprinus carpio carpio, Gobio gobio, Leuciscus idus, Rutilus rutilus, Squalius cephalus, Tinca tinca, Esox lucius, Fundulus heteroclitus heteroclitus, Ameiurus natalis, Ictalurus punctatus, Morone americana, Etheostoma flabellare, Etheostoma nigrum, Perca fluviatilis, Percina nigrofasciata, Sander lucioperca, Oncorhynchus mykiss,  Oncorhynchus gilae, Salmo salar, Salmo trutta fario, Salvelinus fontinalis, Salvelinus malma malma, Thymallus thymallus, Aplodinotus grunniens, Salmo trutta, Gobio gobio, Rutilus rutilus*  
    **l** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fish Length [mm] (If no species is given, range=39-810)  
    **ar** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect Ratio of Caudal Fin (If no species is given) (valid range 0.51 - 2.29)  
    **t** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time interval for model step [d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3650*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **p** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Share of the stationary component (valid range 0 - 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.67*  
    **habitat_attract** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractiveness of habitat used as weighting factor (sink effect, habitat-dependent dispersal)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **habitat_p** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spatially varying and habitat-dependent p factor (float: 0-1, source effect, habitat-dependent dispersal)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **truncation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;kernel truncation criterion (precision)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.9, 0.95, 0.99, 0.995, 0.999, 0.99999, 0.999999999, inf*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.99*  
    **seed1** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for generating dispersal parameters  
    **seed2** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for multinomial realisation step  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fidimo_out*  
    **statistical_interval** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical Intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, Confidence Interval, Prediction Interval, Random Value within Confidence Interval*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *no*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *a*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't keep basic vector maps (source_points, barriers)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep all temporal vector and raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Source population input are real fish counts per cell. Backtransformation into fish counts will be performed.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **river** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;River network (raster, e.g. output from r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **coors** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;River networks' outlet coordinates: E,N  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **barriers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Barrier point file (vector map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector  
    **passability_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name indicating passability value (0-1) of barrier  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **n_source** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Either: Number of random cells with source populations  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *number[%]*  
    **source_populations** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Or: Source population raster (relative or absolute occurrence)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **species** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select fish species  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Custom species, Catostomus commersoni, Moxostoma duquesnii, Moxostoma erythrurum, Ambloplites rupestris, Lepomis auritus, Lepomis cyanellus, Lepomis macrochirus, Lepomis megalotis, Micropterus dolomieui, Micropterus punctulatus, Micropterus salmoides, Pomoxis annularis, Cottus bairdii, Cottus gobio, Abramis brama, Barbus barbus, Cyprinus carpio carpio, Gobio gobio, Leuciscus idus, Rutilus rutilus, Squalius cephalus, Tinca tinca, Esox lucius, Fundulus heteroclitus heteroclitus, Ameiurus natalis, Ictalurus punctatus, Morone americana, Etheostoma flabellare, Etheostoma nigrum, Perca fluviatilis, Percina nigrofasciata, Sander lucioperca, Oncorhynchus mykiss,  Oncorhynchus gilae, Salmo salar, Salmo trutta fario, Salvelinus fontinalis, Salvelinus malma malma, Thymallus thymallus, Aplodinotus grunniens, Salmo trutta, Gobio gobio, Rutilus rutilus*  
    **l** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fish Length [mm] (If no species is given, range=39-810)  
    **ar** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aspect Ratio of Caudal Fin (If no species is given) (valid range 0.51 - 2.29)  
    **t** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time interval for model step [d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-3650*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **p** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Share of the stationary component (valid range 0 - 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.67*  
    **habitat_attract** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attractiveness of habitat used as weighting factor (sink effect, habitat-dependent dispersal)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **habitat_p** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spatially varying and habitat-dependent p factor (float: 0-1, source effect, habitat-dependent dispersal)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **truncation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;kernel truncation criterion (precision)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.9, 0.95, 0.99, 0.995, 0.999, 0.99999, 0.999999999, inf*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.99*  
    **seed1** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for generating dispersal parameters  
    **seed2** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;fixed seed for multinomial realisation step  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fidimo_out*  
    **statistical_interval** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical Intervals  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *no, Confidence Interval, Prediction Interval, Random Value within Confidence Interval*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *no*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *a*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't keep basic vector maps (source_points, barriers)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep all temporal vector and raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Source population input are real fish counts per cell. Backtransformation into fish counts will be performed.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.fidimo* performs analysis of fish dispersal based on leptokurtic
dispersal kernels. It calculates fish dispersal along river corridors
based on a user's stream network input, fish source populations and
species-specific dispersal parameters.

## OPTIONS

### Stream parameters

- **river**  
    Name of input stream network map (thinned raster map) on which the
    calculations of dispersal is performed. In cases of very meandering
    rivers (with bends narrower than the spatial resolution of the
    analysis (cell size) it is recommended to run v.generalize and
    r.thin and/or to use *r.fidimo.river* in advance. The stream network
    should only consist of tree-like structures, as braiding rivers and
    networks with two-side connected side arms will not work. Check the
    raster beforehand carefully\!
- **outflow\_point**  
    Name of the outflow point txt-file (single point) for the
    calculation of the flow direction within the provided river network.
    The text-file must only contain a single |-separated coordinate pair
    (X|Y; same coordinate system as the **river** network raster). The
    file should not contain any headings, etc. e.g. the content of the
    file can look like:

```text
545287.44|1942020.18
```

- **barriers**  
    Name of input barrier text-file indicating the geographical position
    and passability of barriers e.g. weirs. The file should contain the
    X and Y coordinate and a value for passability (0-1 where 0 is
    impassable and 1 is 100% passable). The values must be |-separated:

```text
3543350.8001|6064831.9001|1
3535061.5179|6064457.5321|0.3
```

### Source populations

The source populations can be provided either as random points (flag
-r), or as fixed source population raster (flag -f).

- **n\_source**  
    For the random locations; number or percentage of cells containing
    source populations. The model selects randomly cell (number
    specified by the user) and assigns a starting density of 1 to each
    occupied cell.
- **source\_populations**  
    Input raster map indicating the starting density per cell. All cells
    with densities \> 0 will act as source populations for the model.
    The raster map must have the resolution as the river raster and all
    source population cells must also be part of the river raster.

### Dispersal parameters

- **species**  
    Selected species with predefined L and AR (see R-package
    'fishmove').
- **L**  
    Length of fish which should be modelled. Increasing L is positively
    correlated with larger dispersal distances. Setting L will overwrite
    any species-settings (see R-package 'fishmove').
- **AR**  
    Aspect ratio of the caudal fin of a fish which should be modelled.
    Increasing AR is positively correlated with larger dispersal
    distances. etting AR will overwrite any species-settings (see
    R-package 'fishmove').
- **T**  
    Time interval for one modelling step. The dispersal kernel is time
    dependent and increasing T is positively correlated with larger
    dispersal distances (see R-package 'fishmove').
- **p**  
    Share of the stationary component of the population. The value is
    set to 0.67 by default (my Paper).

### Output

- **output**  
    The base name of the output file(s). The output raster files will be
    %output%\_fit respectively %output%\_lwr and %output%\_upr if a
    statistical interval is set.
- **statistical\_interval**  
    Statistical interval (confidence or prediction) derived from the
    regression analysis (see R-package 'fishmove'). If a statistical
    interval is set, three output maps will be created (fit, lwr and
    upr).

### Dependencies

- RPy2
- NumPy
- SciPy
- Sqlite3
- r.stream.order

## SEE ALSO

*[r.stream.order](https://grass.osgeo.org/grass-stable/manuals/r.stream.order.html),
[r.watershed](https://grass.osgeo.org/grass-stable/manuals/r.watershed.html)*

## REFERENCES

Radinger, J., Kail, J., & Wolter, C. (2014).
FIDIMO — A free and open source GIS-based dispersal model for riverine fish.
*Ecological Informatics, 24*, 238–247.
[https://doi.org/10.1016/j.ecoinf.2013.06.002](https://doi.org/10.1016/j.ecoinf.2013.06.002).

## AUTHOR

Johannes Radinger, Leibniz-Institute of Freshwater Ecology and Inland
Fisheries, Berlin (Germany)

## SOURCE CODE

Available at: [r.fidimo source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.fidimo)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.fidimo))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
