---
name: r.fill.category.py
description: Replaces the values of pixels of a given category with values of the surrounding pixels.
keywords: [ raster, algebra, category ]
---

# r.fill.category.py

Replaces the values of pixels of a given category with values of the surrounding pixels.

=== "Command line"

    **r.fill.category.py**
    [**-k**]
    **input**=*name*
    **output**=*name*
    **category**=*integer*
    [**nsize**=*integer*]
    [**maxiter**=*integer*]
    [**animationfile**=*name*]
    [**quality**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.fill.category.py input=name output=name category=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.fill.category.py***",
        **input**,
        **output**,
        **category**,
        **nsize**=*19*,
        **maxiter**=*100*,
        **animationfile**=*None*,
        **quality**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.fill.category.py", input="name", output="name", category=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_fill_category_py*(**input**,
        **output**,
        **category**,
        **nsize**=*19*,
        **maxiter**=*100*,
        **animationfile**=*None*,
        **quality**=*3*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_fill_category_py(input="name", output="name", category=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **category**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Category to replace  
    **nsize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size in pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *19*  
    **maxiter**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **animationfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for animation output file  
    **quality**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quality factor for animation (1 = highest quality, lowest compression)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Keep intermediate maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **category** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category to replace  
    **nsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size in pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *19*  
    **maxiter** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **animationfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for animation output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **quality** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quality factor for animation (1 = highest quality, lowest compression)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **category** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category to replace  
    **nsize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size in pixel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *19*  
    **maxiter** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of iterations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **animationfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for animation output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **quality** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quality factor for animation (1 = highest quality, lowest compression)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-5*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Keep intermediate maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.fill.category* replaces the values of pixels of a given category with
values of the surrounding pixels and stores the output in a new raster
map layer. The module can be used to eliminate one category from a
raster map without leaving areas with NULL values, like for example when
using *r.reclass.area*.

Areas with the given category are eroded and their pixels value is
replaced with the values given by the mode of the surrounding pixels.

*r.fill.category* iteratively applies *r.neighbors* and *r.mapcalc*
until no pixel of the category to replace is left or the maximum number
of iterations is reached.

Optionally, *r.fill.category* can create an MPEG file animating the
replacement process.

## PARAMETERS

The user controls the process by setting the *neighborhood size* in
pixels and the *maximum number of iterations*.

The *neighborhood size* (**nsize**) controls the size of the moving
window where the mode of the values is used to assign a value to the
pixels of the category to be replaced. Large values of the *neighborhood
size* can speed the process considerably but can also lead to unwanted
effects where pixels with the category to remove are mixed with pixels
with different categories. Small values of *neighborhood size* require a
large number of iterations, therefore longer processing times, but
provide better results when categories are mixed.

The *maximum number of iterations* (**maxiter**) is limited to *999*
because the name of the temporary map at each step uses three digits to
identify the iteration.

## INTERMEDIATE MAPS

To save space, maps generated at each iteration are removed as soon as
they are used. It is possible to keep these maps using the **k** flag.

## ANIMATION

If the user provides the name of an MPEG output file, an animation is
created by combining the raster maps of each step.

The **quality** (1-5) parameter controls the quality of the MPEG, lower
values will yield higher quality images, but with less compression (i.e.
larger MPEG file size). Switching from *quality=1* to *quality=5*
reduces the MPEG file size of about 40%, although the actual compression
ratio depends on the number of frames.

The module *r.out.mpeg* is used to generate the MPEG file, therefore the
program mpeg\_encode (aka ppmtompeg) must be available. See *r.out.mpeg*
manual for more information.

If a name for an MPEG output file is provided but the **k** flag is not
set, intermediate maps are kept during the process and deleted after the
MPEG file has been created.

## EXAMPLE

In this example, the lakes in the *landuse* map in the North Carolina
sample dataset location are replaced by categories of the surrounding
pixels:

```sh
# set the region on the landuse map
g.region rast=landuse@PERMANENT
# replace pixels of category 6 (water) with values of the surrounding pixels
# create a drought.mpg animation file in the current directory
r.fill.category input=landuse@PERMANENT output=landuse_dry category=6 animationfile=./drought.mpg
```

It removes all water pixels in 38 iterations. A *drought.mpg* MPEG file
containing the animation of the replacement sequence is created in the
current directory.

## SEE ALSO

*[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html),
[r.reclass.area](https://grass.osgeo.org/grass-stable/manuals/r.reclass.area.html),
[r.out.mpeg](https://grass.osgeo.org/grass-stable/manuals/r.out.mpeg.html),
[r.fill.gaps](r.fill.gaps.md)*

## AUTHORS

Paolo Zatelli and Stefano Gobbi, DICAM, University of Trento, Italy.

## SOURCE CODE

Available at: [r.fill.category source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.fill.category)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.fill.category))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
