---
name: r.futures.devpressure.py
description: Module for computing development pressure
keywords: [ raster, filter, statistics ]
---

# r.futures.devpressure.py

Module for computing development pressure

=== "Command line"

    **r.futures.devpressure.py**
    [**-n**]
    **input**=*name*
    **output**=*name*
    **method**=*string*
    **size**=*integer*
    [**gamma**=*float*]
    [**scaling_factor**=*float*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.devpressure.py input=name output=name method=gravity size=8
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.devpressure.py***",
        **input**,
        **output**,
        **method**=*"gravity"*,
        **size**=*8*,
        **gamma**=*1.5*,
        **scaling_factor**=*1*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.devpressure.py", input="name", output="name", method="gravity", size=8)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_devpressure_py*(**input**,
        **output**,
        **method**=*"gravity"*,
        **size**=*8*,
        **gamma**=*1.5*,
        **scaling_factor**=*1*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_devpressure_py(input="name", output="name", method="gravity", size=8)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output development pressure raster  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for computing development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    &nbsp;&nbsp;&nbsp;&nbsp;**occurrence**: number of developed cells in window  
    &nbsp;&nbsp;&nbsp;&nbsp;**gravity**: scaling_factor / pow(distance, gamma)  
    &nbsp;&nbsp;&nbsp;&nbsp;**kernel**: scaling_factor \* exp (-2\*distance / gamma)  
    **size**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Half of neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **gamma**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient controlling the influence of distance, needed for method gravity and kernel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **scaling_factor**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor needed for method gravity and kernel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not propagate nulls  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output development pressure raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for computing development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;**occurrence**: number of developed cells in window  
    &nbsp;&nbsp;&nbsp;&nbsp;**gravity**: scaling_factor / pow(distance, gamma)  
    &nbsp;&nbsp;&nbsp;&nbsp;**kernel**: scaling_factor \* exp (-2\*distance / gamma)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Half of neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **gamma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient controlling the influence of distance, needed for method gravity and kernel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **scaling_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor needed for method gravity and kernel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not propagate nulls  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input binary raster map representing development  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output development pressure raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for computing development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;**occurrence**: number of developed cells in window  
    &nbsp;&nbsp;&nbsp;&nbsp;**gravity**: scaling_factor / pow(distance, gamma)  
    &nbsp;&nbsp;&nbsp;&nbsp;**kernel**: scaling_factor \* exp (-2\*distance / gamma)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Half of neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **gamma** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coefficient controlling the influence of distance, needed for method gravity and kernel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.5*  
    **scaling_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor needed for method gravity and kernel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not propagate nulls  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.devpressure* is part of [FUTURES](r.futures.md), land
change model. It computes development pressure, a predictor based on the
number of neighboring developed cells within search distance, weighted
by distance. The development pressure variable plays a special role in
the model, allowing for a feedback between predicted change and change
in subsequent steps.

There are multiple options for calculating development pressure in the
model.

- **occurrence**: simple count of the number of developed cells within
    the specified window size
- **gravity**: defined as scaling\_factor / pow(distance, gamma)
- **kernel**: defined as scaling\_factor \* exp(-2 \* distance /
    gamma)

Coefficient **gamma** is the coefficient controlling the influence of
distance. The best value for gamma is chosen during the model selection
process (TODO).

The input raster is binary, value 1 represents development, value 0 no
development. The neighborhood **size** describes the size of the moving
window in cells (2 \* size + 1).

![image-alt](devpressure_example.png)

Figure: Effect of parameters **size** and **gamma**: a) initial
development, b) gamma = 2, size = 10, c) gamma = 1.5, size = 10, d)
gamma = 1.5, size = 20.

## NOTES

By default NULL values are propagated. This means that the edges of the
resulting map will be NULLs. To avoid that, flag **n** internally
enlarges the computational region, converts NULLs to zeros, performs the
computation and then patches back the original NULL values.

Module *r.futures.devpressure*, although written for FUTURES model, is
general enough to be used for different applications where distance
pressure can be described with the functions above.

## EXAMPLES

```sh
r.futures.devpressure input=developed output=pressure gamma=1.5 size=10 method=gravity
```

## SEE ALSO

[FUTURES](r.futures.md), *[r.futures.pga](r.futures.pga.md)*,
*[r.futures.calib](r.futures.calib.md)*,
*[r.futures.demand](r.futures.demand.md)*,
*[r.sample.category](r.sample.category.md)*

## REFERENCES

- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.devpressure source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.devpressure)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.devpressure))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
