---
name: r.futures.gridvalidation.py
description: Module for validating land change simulation on a grid
keywords: [ raster, statistics, accuracy, validation ]
---

# r.futures.gridvalidation.py

Module for validating land change simulation on a grid

=== "Command line"

    **r.futures.gridvalidation.py**
    **simulated**=*name*
    **reference**=*name*
    [**original**=*name*]
    [**allocation_disagreement**=*name*]
    [**allocation_disagreement_basename**=*basename*]
    [**quantity_disagreement**=*name*]
    [**quantity_disagreement_basename**=*basename*]
    [**kappa**=*name*]
    [**kappasimulation**=*name*]
    **region**=*name*
    **nprocs**=*integer*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.gridvalidation.py simulated=name reference=name allocation_disagreement=name region=name nprocs=1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.gridvalidation.py***",
        **simulated**,
        **reference**,
        **original**=*None*,
        **allocation_disagreement**=*None*,
        **allocation_disagreement_basename**=*None*,
        **quantity_disagreement**=*None*,
        **quantity_disagreement_basename**=*None*,
        **kappa**=*None*,
        **kappasimulation**=*None*,
        **region**,
        **nprocs**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.gridvalidation.py", simulated="name", reference="name", allocation_disagreement="name", region="name", nprocs=1)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_gridvalidation_py*(**simulated**,
        **reference**,
        **original**=*None*,
        **allocation_disagreement**=*None*,
        **allocation_disagreement_basename**=*None*,
        **quantity_disagreement**=*None*,
        **quantity_disagreement_basename**=*None*,
        **kappa**=*None*,
        **kappasimulation**=*None*,
        **region**,
        **nprocs**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_gridvalidation_py(simulated="name", reference="name", allocation_disagreement="name", region="name", nprocs=1)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **simulated**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated land use raster  
    **reference**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference land use raster  
    **original**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Original land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Required for kappa simulation  
    **allocation_disagreement**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output total allocation disagreement raster  
    **allocation_disagreement_basename**=*basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for per class allocation disagreement raster  
    **quantity_disagreement**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output total quantity disagreement raster  
    **quantity_disagreement_basename**=*basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for per class quantity disagreement raster  
    **kappa**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Cohen's kappa raster  
    **kappasimulation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output kappa simulation raster  
    **region**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of saved region  
    **nprocs**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **simulated** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **reference** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **original** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Original land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Required for kappa simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **allocation_disagreement** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output total allocation disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **allocation_disagreement_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for per class allocation disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **quantity_disagreement** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output total quantity disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **quantity_disagreement_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for per class quantity disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **kappa** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Cohen's kappa raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **kappasimulation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output kappa simulation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **region** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of saved region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **simulated** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Simulated land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **reference** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reference land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **original** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Original land use raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Required for kappa simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **allocation_disagreement** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output total allocation disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **allocation_disagreement_basename** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for per class allocation disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **quantity_disagreement** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output total quantity disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **quantity_disagreement_basename** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for per class quantity disagreement raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **kappa** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Cohen's kappa raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **kappasimulation** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output kappa simulation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **region** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of saved region  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region, *name*  
    **nprocs** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.gridvalidation* allows to validate land change
simulation results on a spatial grid. It computes:

- Allocation disagreement (total and per class), see Pontius et al,
    2011
- Quantity disagreement (total and per class), see Pontius et al, 2011
- Cohen's Kappa
- Kappa simulation, see van Vliet et al, 2011

These metrics are computed for each cell of a region provided in
**region** option resulting in spatially variable validation results.
Cell size of the region should be larger than the cell size of the
current region.

This module can be used for any number of classes. Input raster
**original** represents the initial conditions and is needed only for
Kappa simulation.

## EXAMPLES

Validate FUTURES output by computing quantity and allocation
disagreement on a 5km grid. First reclassify FUTURES output to 0
(undeveloped) and 1 (developed) by creating a text file "rules.txt" with
the following content:

```text
-1 = 0
0 thru 100 = 1
```

Then save a region used as a grid:

```sh
g.region res=5000 -a save=grid
```

Reclass FUTURES output:

```sh
r.reclass input=simulated_2016 output=simulated_2016_reclass rules=rules.txt
```

Validate FUTURES output by computing kappa simulation on a 5km grid:

```sh
r.futures.gridvalidation simulated=simulated_2016_reclass reference=reference_2016 original=orig_2001 kappasimulation=kappasim
```

## SEE ALSO

[FUTURES](r.futures.md), *[r.futures.pga](r.futures.pga.md)*,
*[r.futures.potential](r.futures.potential.md)*,
*[r.futures.devpressure](r.futures.devpressure.md)*,
*[r.futures.demand](r.futures.demand.md)*,
*[r.futures.calib](r.futures.calib.md)*,
*[r.sample.category](r.sample.category.md)*

## REFERENCES

- Robert Gilmore Pontius Jr & Marco Millones (2011). [Death to Kappa:
    birth of quantity disagreement and allocation disagreement for
    accuracy assessment](https://doi.org/10.1080/01431161.2011.552923).
    International Journal of Remote Sensing, 32:15, 4407-4429
- Jasper van Vliet, Arnold K. Bregt, Alex Hagen-Zanker (2011)
    [Revisiting Kappa to account for change in the accuracy assessment
    of land-use change
    models](https://doi.org/10.1016/j.ecolmodel.2011.01.017). Ecological
    Modelling, Volume 222, Issue 8.
- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807. DOI:
    10.1080/00045608.2012.707591
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39. DOI:
    10.1016/j.landurbplan.2014.11.011
- Petrasova, A., Petras, V., Van Berkel, D., Harmon, B. A., Mitasova,
    H., & Meentemeyer, R. K. (2016). [Open Source Approach to Urban
    Growth
    Simulation](https://isprs-archives.copernicus.org/articles/XLI-B7/953/2016/isprs-archives-XLI-B7-953-2016.pdf).
    Int. Arch. Photogramm. Remote Sens. Spatial Inf. Sci., XLI-B7,
    953-959. DOI: 10.5194/isprsarchives-XLI-B7-953-2016

## AUTHOR

Anna Petrasova, [NCSU
GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.gridvalidation source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.gridvalidation)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.gridvalidation))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
