---
name: r.futures.pga
description: Simulates landuse change using FUTure Urban-Regional Environment Simulation (FUTURES). Module uses Patch-Growing Algorithm (PGA) to simulate urban-rural landscape structure development.
keywords: [ raster, patch growing, urban, landscape, modeling ]
---

# r.futures.pga

Simulates landuse change using FUTure Urban-Regional Environment Simulation (FUTURES).

Module uses Patch-Growing Algorithm (PGA) to simulate urban-rural landscape structure development.

=== "Command line"

    **r.futures.pga**
    [**-s**]
    **developed**=*name*
    **subregions**=*name*
    [**subregions_potential**=*name*]
    **predictors**=*name* [,*name*,...]
    **development_pressure**=*name*
    **n_dev_neighbourhood**=*integer*
    **development_pressure_approach**=*string*
    **gamma**=*float*
    **scaling_factor**=*float*
    **output**=*name*
    [**output_series**=*basename*]
    **devpot_params**=*name*
    **demand**=*name*
    [**separator**=*character*]
    **patch_sizes**=*name*
    **num_neighbors**=*integer*
    **discount_factor**=*float*
    **seed_search**=*string*
    **compactness_mean**=*float*
    **compactness_range**=*float*
    [**num_steps**=*integer*]
    [**potential_weight**=*name*]
    [**incentive_power**=*float*]
    [**random_seed**=*integer*]
    [**memory**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.futures.pga developed=name subregions=name predictors=name development_pressure=name n_dev_neighbourhood=0 development_pressure_approach=gravity gamma=0.0 scaling_factor=0.0 output=name devpot_params=name demand=name patch_sizes=name num_neighbors=4 discount_factor=0.0 seed_search=probability compactness_mean=0.0 compactness_range=0.0 random_seed=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.futures.pga***",
        **developed**,
        **subregions**,
        **subregions_potential**=*None*,
        **predictors**,
        **development_pressure**,
        **n_dev_neighbourhood**,
        **development_pressure_approach**=*"gravity"*,
        **gamma**,
        **scaling_factor**,
        **output**,
        **output_series**=*None*,
        **devpot_params**,
        **demand**,
        **separator**=*"comma"*,
        **patch_sizes**,
        **num_neighbors**=*4*,
        **discount_factor**,
        **seed_search**=*"probability"*,
        **compactness_mean**,
        **compactness_range**,
        **num_steps**=*None*,
        **potential_weight**=*None*,
        **incentive_power**=*1*,
        **random_seed**=*None*,
        **memory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.futures.pga", developed="name", subregions="name", predictors="name", development_pressure="name", n_dev_neighbourhood=0, development_pressure_approach="gravity", gamma=0.0, scaling_factor=0.0, output="name", devpot_params="name", demand="name", patch_sizes="name", num_neighbors=4, discount_factor=0.0, seed_search="probability", compactness_mean=0.0, compactness_range=0.0, random_seed=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_futures_pga*(**developed**,
        **subregions**,
        **subregions_potential**=*None*,
        **predictors**,
        **development_pressure**,
        **n_dev_neighbourhood**,
        **development_pressure_approach**=*"gravity"*,
        **gamma**,
        **scaling_factor**,
        **output**,
        **output_series**=*None*,
        **devpot_params**,
        **demand**,
        **separator**=*"comma"*,
        **patch_sizes**,
        **num_neighbors**=*4*,
        **discount_factor**,
        **seed_search**=*"probability"*,
        **compactness_mean**,
        **compactness_range**,
        **num_steps**=*None*,
        **potential_weight**=*None*,
        **incentive_power**=*1*,
        **random_seed**=*None*,
        **memory**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_futures_pga(developed="name", subregions="name", predictors="name", development_pressure="name", n_dev_neighbourhood=0, development_pressure_approach="gravity", gamma=0.0, scaling_factor=0.0, output="name", devpot_params="name", demand="name", patch_sizes="name", num_neighbors=4, discount_factor=0.0, seed_search="probability", compactness_mean=0.0, compactness_range=0.0, random_seed=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **developed**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    **subregions**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    **subregions_potential**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    **predictors**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Listed in the same order as in the development potential table  
    **development_pressure**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    **n_dev_neighbourhood**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **development_pressure_approach**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **gamma**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;State of the development at the end of simulation  
    **output_series**=*basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for raster maps of development generated after each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    **devpot_params**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters (intercepts, development pressure, other predictors). First line is ignored, so it can be used for header  
    **demand**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with number of cells to convert for each step and subregion  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input CSV files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **patch_sizes**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing list of patch sizes to use  
    **num_neighbors**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **discount_factor**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Discount factor of patch size  
    **seed_search**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined (1: uniform distribution 2: development probability)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *probability*  
    **compactness_mean**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean value of patch compactness to control patch shapes  
    **compactness_range**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Range of patch compactness to control patch shapes  
    **num_steps**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **potential_weight**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reducesprobability and positive increases probability.  
    **incentive_power**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **random_seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **memory**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in GB  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically generates random seed for random number generator (use when you don't want to provide the seed option)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **developed** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions_potential** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **predictors** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Listed in the same order as in the development potential table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **development_pressure** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **n_dev_neighbourhood** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **development_pressure_approach** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **gamma** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;State of the development at the end of simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_series** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for raster maps of development generated after each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **devpot_params** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters (intercepts, development pressure, other predictors). First line is ignored, so it can be used for header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **demand** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with number of cells to convert for each step and subregion  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input CSV files  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **patch_sizes** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing list of patch sizes to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **num_neighbors** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **discount_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discount factor of patch size  
    **seed_search** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined (1: uniform distribution 2: development probability)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *probability*  
    **compactness_mean** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean value of patch compactness to control patch shapes  
    **compactness_range** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range of patch compactness to control patch shapes  
    **num_steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **potential_weight** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reducesprobability and positive increases probability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **incentive_power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in GB  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatically generates random seed for random number generator (use when you don't want to provide the seed option)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **developed** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of developed areas (=1), undeveloped (=0) and excluded (no data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **subregions_potential** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of subregions used with potential file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, the raster specified in subregions parameter is used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **predictors** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of predictor variable raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Listed in the same order as in the development potential table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **development_pressure** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **n_dev_neighbourhood** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of square used to recalculate development pressure  
    **development_pressure_approach** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Approaches to derive development pressure  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *occurrence, gravity, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gravity*  
    **gamma** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Influence of distance between neighboring cells  
    **scaling_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor of development pressure  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;State of the development at the end of simulation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **output_series** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for raster maps of development generated after each step  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output basename raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **devpot_params** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with development potential parameters for each region  
    &nbsp;&nbsp;&nbsp;&nbsp;Each line should contain region ID followed by parameters (intercepts, development pressure, other predictors). First line is ignored, so it can be used for header  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **demand** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV file with number of cells to convert for each step and subregion  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input CSV files  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *comma*  
    **patch_sizes** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing list of patch sizes to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **num_neighbors** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of neighbors to be used for patch generation (4 or 8)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *4, 8*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **discount_factor** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discount factor of patch size  
    **seed_search** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The way location of a seed is determined (1: uniform distribution 2: development probability)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *random, probability*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *probability*  
    **compactness_mean** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean value of patch compactness to control patch shapes  
    **compactness_range** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range of patch compactness to control patch shapes  
    **num_steps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to be simulated  
    **potential_weight** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map of weights altering development potential  
    &nbsp;&nbsp;&nbsp;&nbsp;Values need to be between -1 and 1, where negative locally reducesprobability and positive increases probability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **incentive_power** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent to transform probability values p to p^x to simulate infill vs. sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Values &gt; 1 encourage infill, &lt; 1 urban sprawl  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **memory** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in GB  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatically generates random seed for random number generator (use when you don't want to provide the seed option)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.futures.pga* is part of [FUTURES](r.futures.md) land change
model. This module uses stochastic Patch-Growing Algorithm (PGA) and a
combination of field-based and object-based representations to simulate
land changes. PGA simulates undeveloped to developed land change by
iterative site selection and a contextually aware region growing
mechanism. Simulations of change at each time step feed development
pressure back to the POTENTIAL submodel, influencing site suitability
for the next step.

### Patch growing

Patches are constructed in three steps. First, a potential seed is
randomly selected from available cells. In case **seed\_search** is
*probability*, the probability value (based on POTENTIAL) of the seed is
tested using Monte Carlo approach, and if it doesn't survive, new
potential seed is selected and tested. Second, using a 4- or 8-neighbor
(see **num\_neighbors**) search rule PGA grows the patch. PGA decides on
the suitability of contiguous cells based on their underlying
development potential and distance to the seed adjusted by compactness
parameter given in **compactness\_mean** and **compactness\_range**. The
size of the patch is determined by randomly selecting a patch size from
**patch sizes** file and multiplied by **discount\_factor**. To find
optimal values for patch sizes and compactness, use module
*[r.futures.calib](r.futures.calib.md)*. Once a cell is converted, it
remains developed. PGA continues to grow patches until the per capita
land demand is satisfied.

### Development pressure

Development pressure is a dynamic spatial variable derived from the
patch-building process of PGA and associated with the POTENTIAL
submodel. At each time step, PGA updates the POTENTIAL probability
surface based on land change, and the new development pressure then
affects future land change. The initial development pressure is computed
using module *[r.futures.devpressure](r.futures.devpressure.md)*. The
same input parameters of this module (**gamma**, **scaling factor** and
**n\_dev\_neighbourhood**) are then used as input for
*[r.futures.pga](r.futures.pga.md)*.

### Scenarios

Scenarios involving policies that encourage infill versus sprawl can be
explored using the **incentive\_power** parameter, which uses a power
function to transform the probability in POTENTIAL.

![image-alt](incentive.png)

Figure: Transforming development potential surface using incentive
tables with different power functions.

![image-alt](r_futures_scenario_infill.png)
![image-alt](r_futures_scenario_status_quo.png)
![image-alt](r_futures_scenario_sprawl.png)

Figure: Effect of incentive table on development probability: infill
(left), status quo (middle), sprawl (right) scenario.

Additionally, parameter **potential\_weight** (raster map from -1 to 1)
enables to include policies (such as new regulations or fees) which
limit or encourage development in certain areas. Where
**potential\_weight** values are lower than 0, the probability surface
is simply multiplied by the values, which results in decreased site
suitability. Similarly, values greater than 0 result in increased site
suitability. The probability surface is transformed from initial
probability *p* with value *w* to p + w - p \* w.

### Output

After the simulation ends, raster specified in parameter **output** is
written. If optional parameter **output\_series** is specified,
additional output is a series of raster maps for each step. Cells with
value 0 represents the initial development, values \>= 1 then represent
the step in which the cell was developed. Undeveloped cells have value
-1.

![image-alt](r_futures.png)

Figure: Output map of developed areas

![image-alt](r_futures_detail.png)

Figure: Detail of output map

## EXAMPLE

```sh
r.futures.pga -s developed=lc96 predictors=d2urbkm,d2intkm,d2rdskm,slope \
  demand=demand.txt devpot_params=devpotParams.csv discount_factor=0.6 \
  compactness_mean=0.4 compactness_range=0.08 num_neighbors=4 seed_search=probability \
  patch_sizes=patch_sizes.txt development_pressure=gdp n_dev_neighbourhood=10 \
  development_pressure_approach=gravity gamma=2 scaling_factor=1 \
  subregions=subregions incentive_power=2 \
  potential_weight=weight_1 output=final_results output_series=development
```

## REFERENCES

- Meentemeyer, R. K., Tang, W., Dorning, M. A., Vogler, J. B.,
    Cunniffe, N. J., & Shoemaker, D. A. (2013). [FUTURES: Multilevel
    Simulations of Emerging Urban-Rural Landscape Structure Using a
    Stochastic Patch-Growing
    Algorithm](https://doi.org/10.1080/00045608.2012.707591). Annals of
    the Association of American Geographers, 103(4), 785-807.
- Dorning, M. A., Koch, J., Shoemaker, D. A., & Meentemeyer, R. K.
    (2015). [Simulating urbanization scenarios reveals tradeoffs between
    conservation planning
    strategies](https://doi.org/10.1016/j.landurbplan.2014.11.011).
    Landscape and Urban Planning, 136, 28-39.

## SEE ALSO

[FUTURES](r.futures.md),
*[r.futures.devpressure](r.futures.devpressure.md)*,
*[r.futures.calib](r.futures.calib.md)*,
*[r.futures.demand](r.futures.demand.md)*,
*[r.futures.potential](r.futures.potential.md)*,
*[r.futures.parallelpga](r.futures.parallelpga.md)*,
*[r.sample.category](r.sample.category.md)*

## AUTHORS

*Corresponding author:*  
Ross K. Meentemeyer, rkmeente ncsu edu, [Center for Geospatial
Analytics, NCSU](https://geospatial.ncsu.edu/)

*Original standalone version:*  
Ross K. Meentemeyer \*  
Wenwu Tang \*  
Monica A. Dorning \*  
John B. Vogler \*  
Nik J. Cunniffe \*  
Douglas A. Shoemaker \*  
Jennifer A. Koch \*\*  
  
\* Department of Geography and Earth Sciences, UNC Charlotte  
\*\* [Center for Geospatial Analytics,
NCSU](https://geospatial.ncsu.edu/)  

*Port to GRASS GIS and GRASS-specific additions:*  
Anna Petrasova, [NCSU
GeoForAll](https://geospatial.ncsu.edu/geoforall/)  
Vaclav Petras, [NCSU
GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.futures.pga source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.futures/r.futures.pga)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.futures/r.futures.pga))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
