---
name: r.green.biomassfor.co2.py
description: Calculates impact and multifunctionality values
keywords: [ raster, biomass ]
---

# r.green.biomassfor.co2.py

Calculates impact and multifunctionality values

=== "Command line"

    **r.green.biomassfor.co2.py**
    [**-r**]
    **forest**=*name*
    **boundaries**=*name*
    **forest_column_yield**=*string*
    **forest_column_yield_surface**=*string*
    **forest_column_management**=*string*
    **forest_column_treatment**=*string*
    **forest_roads**=*name*
    [**forest_column_roughness**=*string*]
    [**rivers**=*name*]
    [**lakes**=*name*]
    [**energy_tops_hf**=*float*]
    [**energy_cormometric_vol_hf**=*float*]
    [**energy_tops_cop**=*float*]
    **energy_map**=*name*
    **dhp**=*name*
    [**output_basename_co2map**=*name*]
    [**output_basename_aco2map**=*name*]
    [**output_basename_nco2map**=*name*]
    [**dtm**=*name*]
    [**forest_column_roughness**=*string*]
    [**soilp2_map**=*name*]
    [**tree_diam**=*name*]
    [**tree_vol**=*name*]
    [**main_roads**=*name*]
    [**slp_min_cc**=*float*]
    [**slp_max_cc**=*float*]
    [**dist_max_cc**=*float*]
    [**slp_max_fw**=*float*]
    [**dist_max_fw**=*float*]
    [**slp_max_cop**=*float*]
    [**dist_max_cop**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.biomassfor.co2.py forest=name boundaries=name forest_column_yield=string forest_column_yield_surface=string forest_column_management=string forest_column_treatment=string forest_roads=name energy_map=name dhp=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.biomassfor.co2.py***",
        **forest**,
        **boundaries**,
        **forest_column_yield**,
        **forest_column_yield_surface**,
        **forest_column_management**,
        **forest_column_treatment**,
        **forest_roads**,
        **forest_column_roughness**=*None*,
        **rivers**=*None*,
        **lakes**=*None*,
        **energy_tops_hf**=*0.49*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **energy_map**,
        **dhp**,
        **output_basename_co2map**=*None*,
        **output_basename_aco2map**=*None*,
        **output_basename_nco2map**=*None*,
        **dtm**=*None*,
        **forest_column_roughness**=*None*,
        **soilp2_map**=*None*,
        **tree_diam**=*None*,
        **tree_vol**=*None*,
        **main_roads**=*None*,
        **slp_min_cc**=*30.*,
        **slp_max_cc**=*100.*,
        **dist_max_cc**=*800.*,
        **slp_max_fw**=*30.*,
        **dist_max_fw**=*600.*,
        **slp_max_cop**=*30.*,
        **dist_max_cop**=*600.*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.biomassfor.co2.py", forest="name", boundaries="name", forest_column_yield="string", forest_column_yield_surface="string", forest_column_management="string", forest_column_treatment="string", forest_roads="name", energy_map="name", dhp="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_biomassfor_co2_py*(**forest**,
        **boundaries**,
        **forest_column_yield**,
        **forest_column_yield_surface**,
        **forest_column_management**,
        **forest_column_treatment**,
        **forest_roads**,
        **forest_column_roughness**=*None*,
        **rivers**=*None*,
        **lakes**=*None*,
        **energy_tops_hf**=*0.49*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **energy_map**,
        **dhp**,
        **output_basename_co2map**=*None*,
        **output_basename_aco2map**=*None*,
        **output_basename_nco2map**=*None*,
        **dtm**=*None*,
        **forest_column_roughness**=*None*,
        **soilp2_map**=*None*,
        **tree_diam**=*None*,
        **tree_vol**=*None*,
        **main_roads**=*None*,
        **slp_min_cc**=*30.*,
        **slp_max_cc**=*100.*,
        **dist_max_cc**=*800.*,
        **slp_max_fw**=*30.*,
        **dist_max_fw**=*600.*,
        **slp_max_cop**=*30.*,
        **dist_max_cop**=*600.*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_biomassfor_co2_py(forest="name", boundaries="name", forest_column_yield="string", forest_column_yield_surface="string", forest_column_management="string", forest_column_treatment="string", forest_roads="name", energy_map="name", dhp="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **forest**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    **boundaries**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    **forest_column_yield**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_roads**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    **forest_column_roughness**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **rivers**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    **lakes**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    **energy_tops_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **energy_map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy map in MWh/m3  
    **dhp**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    **output_basename_co2map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CO2 emissions map  
    **output_basename_aco2map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output avoided CO2 emissions map  
    **output_basename_nco2map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output net CO2 emissions map  
    **dtm**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Digital terrain model map  
    **forest_column_roughness**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **soilp2_map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil production map  
    **tree_diam**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree diameter map  
    **tree_vol**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree volume map  
    **main_roads**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    **slp_min_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **boundaries** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_yield** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **rivers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **energy_map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy map in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dhp** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output_basename_co2map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CO2 emissions map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **output_basename_aco2map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output avoided CO2 emissions map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **output_basename_nco2map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output net CO2 emissions map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **dtm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Digital terrain model map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **soilp2_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil production map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_diam** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree diameter map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_vol** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree volume map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **main_roads** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **slp_min_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **boundaries** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_yield** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **rivers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **energy_map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bioenergy map in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dhp** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output_basename_co2map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output CO2 emissions map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **output_basename_aco2map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output avoided CO2 emissions map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **output_basename_nco2map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output net CO2 emissions map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **dtm** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Digital terrain model map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **soilp2_map** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil production map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_diam** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree diameter map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_vol** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree volume map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **main_roads** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **slp_min_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Compute the CO2 emissions of using biomass forestry residuals for energy
production.

## NOTES

## EXAMPLE

## REFERENCE

## SEE ALSO

*[r.green](r.green.md), [r.green.biomassfor](r.green.biomassfor.md)*

## AUTHORS

Francesco Geri, Pietro Zambelli, Sandro Sacchelli, Marco Ciolli

## SOURCE CODE

Available at: [r.green.biomassfor.co2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.biomassfor/r.green.biomassfor.co2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.biomassfor/r.green.biomassfor.co2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
