---
name: r.green.biomassfor.financial.py
description: Estimates bioenergy that can be collected to supply heating plants or biomass logistic centres and that is associated with a positive net revenue for the entire production process
keywords: [ raster, biomass ]
---

# r.green.biomassfor.financial.py

Estimates bioenergy that can be collected to supply heating plants or biomass logistic centres and that is associated with a positive net revenue for the entire production process

=== "Command line"

    **r.green.biomassfor.financial.py**
    [**-r**]
    **forest**=*name*
    **dhp**=*name*
    **forest_column_yield**=*string*
    **forest_column_yield_surface**=*string*
    **forest_column_management**=*string*
    **forest_column_treatment**=*string*
    **forest_column_wood_price**=*string*
    **forest_roads**=*name*
    **main_roads**=*name*
    **elevation**=*name*
    [**technical_bioenergy**=*name*]
    [**tech_bioc**=*name*]
    [**tech_biohf**=*name*]
    [**soilp2_map**=*name*]
    [**tree_diam**=*name*]
    [**tree_vol**=*name*]
    [**rivers**=*name*]
    [**lakes**=*name*]
    [**forest_column_roughness**=*string*]
    [**slp_min_cc**=*float*]
    [**slp_max_cc**=*float*]
    [**dist_max_cc**=*float*]
    [**slp_max_fw**=*float*]
    [**dist_max_fw**=*float*]
    [**slp_max_cop**=*float*]
    [**dist_max_cop**=*float*]
    [**price_energy_woodchips**=*float*]
    [**cost_chainsaw**=*float*]
    [**cost_processor**=*float*]
    [**cost_harvester**=*float*]
    [**cost_cablehf**=*float*]
    [**cost_cablec**=*float*]
    [**cost_forwarder**=*float*]
    [**cost_skidder**=*float*]
    [**cost_chipping**=*float*]
    [**cost_transport**=*float*]
    [**ton_tops_hf**=*float*]
    [**ton_vol_hf**=*float*]
    [**ton_tops_cop**=*float*]
    **econ_bioenergy**=*name*
    **net_revenues**=*name*
    [**total_revenues**=*name*]
    [**total_cost**=*name*]
    [**econ_bioenergyhf**=*name*]
    [**econ_bioenergyc**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.biomassfor.financial.py forest=name dhp=name forest_column_yield=string forest_column_yield_surface=string forest_column_management=string forest_column_treatment=string forest_column_wood_price=string forest_roads=name main_roads=name elevation=name econ_bioenergy=name net_revenues=net_revenues
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.biomassfor.financial.py***",
        **forest**,
        **dhp**,
        **forest_column_yield**,
        **forest_column_yield_surface**,
        **forest_column_management**,
        **forest_column_treatment**,
        **forest_column_wood_price**,
        **forest_roads**,
        **main_roads**,
        **elevation**,
        **technical_bioenergy**=*None*,
        **tech_bioc**=*None*,
        **tech_biohf**=*None*,
        **soilp2_map**=*None*,
        **tree_diam**=*None*,
        **tree_vol**=*None*,
        **rivers**=*None*,
        **lakes**=*None*,
        **forest_column_roughness**=*None*,
        **slp_min_cc**=*30.*,
        **slp_max_cc**=*100.*,
        **dist_max_cc**=*800.*,
        **slp_max_fw**=*30.*,
        **dist_max_fw**=*600.*,
        **slp_max_cop**=*30.*,
        **dist_max_cop**=*600.*,
        **price_energy_woodchips**=*19.50*,
        **cost_chainsaw**=*13.17*,
        **cost_processor**=*87.42*,
        **cost_harvester**=*96.33*,
        **cost_cablehf**=*111.44*,
        **cost_cablec**=*104.31*,
        **cost_forwarder**=*70.70*,
        **cost_skidder**=*64.36*,
        **cost_chipping**=*150.87*,
        **cost_transport**=*64.90*,
        **ton_tops_hf**=*0.25*,
        **ton_vol_hf**=*1*,
        **ton_tops_cop**=*0.28*,
        **econ_bioenergy**,
        **net_revenues**=*"net_revenues"*,
        **total_revenues**=*None*,
        **total_cost**=*None*,
        **econ_bioenergyhf**=*None*,
        **econ_bioenergyc**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.biomassfor.financial.py", forest="name", dhp="name", forest_column_yield="string", forest_column_yield_surface="string", forest_column_management="string", forest_column_treatment="string", forest_column_wood_price="string", forest_roads="name", main_roads="name", elevation="name", econ_bioenergy="name", net_revenues="net_revenues")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_biomassfor_financial_py*(**forest**,
        **dhp**,
        **forest_column_yield**,
        **forest_column_yield_surface**,
        **forest_column_management**,
        **forest_column_treatment**,
        **forest_column_wood_price**,
        **forest_roads**,
        **main_roads**,
        **elevation**,
        **technical_bioenergy**=*None*,
        **tech_bioc**=*None*,
        **tech_biohf**=*None*,
        **soilp2_map**=*None*,
        **tree_diam**=*None*,
        **tree_vol**=*None*,
        **rivers**=*None*,
        **lakes**=*None*,
        **forest_column_roughness**=*None*,
        **slp_min_cc**=*30.*,
        **slp_max_cc**=*100.*,
        **dist_max_cc**=*800.*,
        **slp_max_fw**=*30.*,
        **dist_max_fw**=*600.*,
        **slp_max_cop**=*30.*,
        **dist_max_cop**=*600.*,
        **price_energy_woodchips**=*19.50*,
        **cost_chainsaw**=*13.17*,
        **cost_processor**=*87.42*,
        **cost_harvester**=*96.33*,
        **cost_cablehf**=*111.44*,
        **cost_cablec**=*104.31*,
        **cost_forwarder**=*70.70*,
        **cost_skidder**=*64.36*,
        **cost_chipping**=*150.87*,
        **cost_transport**=*64.90*,
        **ton_tops_hf**=*0.25*,
        **ton_vol_hf**=*1*,
        **ton_tops_cop**=*0.28*,
        **econ_bioenergy**,
        **net_revenues**=*"net_revenues"*,
        **total_revenues**=*None*,
        **total_cost**=*None*,
        **econ_bioenergyhf**=*None*,
        **econ_bioenergyc**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_biomassfor_financial_py(forest="name", dhp="name", forest_column_yield="string", forest_column_yield_surface="string", forest_column_management="string", forest_column_treatment="string", forest_column_wood_price="string", forest_roads="name", main_roads="name", elevation="name", econ_bioenergy="name", net_revenues="net_revenues")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **forest**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    **dhp**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    **forest_column_yield**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_column_wood_price**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of wood prices  
    **forest_roads**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    **main_roads**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **technical_bioenergy**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total technical biomass potential [MWh/year]  
    **tech_bioc**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Technical biomass potential for coppices [MWh/year]  
    **tech_biohf**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Technical biomass potential in high forest [MWh/year]  
    **soilp2_map**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil production map  
    **tree_diam**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree diameter map  
    **tree_vol**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree volume map  
    **rivers**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    **lakes**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    **forest_column_roughness**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **slp_min_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **price_energy_woodchips**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Price for energy from woodchips EUR/MWh  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *19.50*  
    **cost_chainsaw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Felling and/or felling-processing cost with chainsaw EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *13.17*  
    **cost_processor**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Processing cost with processor EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *87.42*  
    **cost_harvester**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Felling and processing cost with harvester EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96.33*  
    **cost_cablehf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with high power cable crane EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *111.44*  
    **cost_cablec**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with medium power cable crane EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *104.31*  
    **cost_forwarder**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with forwarder EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *70.70*  
    **cost_skidder**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with skidder EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *64.36*  
    **cost_chipping**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chipping cost EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *150.87*  
    **cost_transport**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transport with truck EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *64.90*  
    **ton_tops_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for tops and branches in high forest [ton/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **ton_vol_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for the whole tree in high forest (tops, branches and stem) in ton/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **ton_tops_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for tops and branches for Coppices in ton/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.28*  
    **econ_bioenergy**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy [Mwh/year]  
    **net_revenues**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the net present value [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *net_revenues*  
    **total_revenues**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the total revenues [EUR/year]  
    **total_cost**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the total cost [EUR/year]  
    **econ_bioenergyhf**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy in high forest [Mwh/year]  
    **econ_bioenergyc**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy for coppices[Mwh/year]  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **dhp** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_yield** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_column_wood_price** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of wood prices  
    **forest_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **main_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **technical_bioenergy** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total technical biomass potential [MWh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tech_bioc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Technical biomass potential for coppices [MWh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tech_biohf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Technical biomass potential in high forest [MWh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilp2_map** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil production map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_diam** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree diameter map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_vol** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree volume map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rivers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **slp_min_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **price_energy_woodchips** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Price for energy from woodchips EUR/MWh  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *19.50*  
    **cost_chainsaw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Felling and/or felling-processing cost with chainsaw EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *13.17*  
    **cost_processor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Processing cost with processor EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *87.42*  
    **cost_harvester** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Felling and processing cost with harvester EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96.33*  
    **cost_cablehf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with high power cable crane EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *111.44*  
    **cost_cablec** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with medium power cable crane EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *104.31*  
    **cost_forwarder** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with forwarder EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *70.70*  
    **cost_skidder** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with skidder EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *64.36*  
    **cost_chipping** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chipping cost EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *150.87*  
    **cost_transport** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transport with truck EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *64.90*  
    **ton_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for tops and branches in high forest [ton/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **ton_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for the whole tree in high forest (tops, branches and stem) in ton/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **ton_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for tops and branches for Coppices in ton/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.28*  
    **econ_bioenergy** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy [Mwh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **net_revenues** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the net present value [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *net_revenues*  
    **total_revenues** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the total revenues [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **total_cost** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the total cost [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **econ_bioenergyhf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy in high forest [Mwh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **econ_bioenergyc** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy for coppices[Mwh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **dhp** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector district heating points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_yield** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_column_wood_price** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of wood prices  
    **forest_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **main_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of main roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **technical_bioenergy** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total technical biomass potential [MWh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tech_bioc** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Technical biomass potential for coppices [MWh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tech_biohf** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Technical biomass potential in high forest [MWh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soilp2_map** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Soil production map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_diam** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree diameter map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **tree_vol** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Average tree volume map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **rivers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **slp_min_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **price_energy_woodchips** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Price for energy from woodchips EUR/MWh  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *19.50*  
    **cost_chainsaw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Felling and/or felling-processing cost with chainsaw EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *13.17*  
    **cost_processor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Processing cost with processor EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *87.42*  
    **cost_harvester** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Felling and processing cost with harvester EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *96.33*  
    **cost_cablehf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with high power cable crane EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *111.44*  
    **cost_cablec** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with medium power cable crane EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *104.31*  
    **cost_forwarder** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with forwarder EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *70.70*  
    **cost_skidder** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Extraction cost with skidder EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *64.36*  
    **cost_chipping** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chipping cost EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *150.87*  
    **cost_transport** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Transport with truck EUR/h  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *64.90*  
    **ton_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for tops and branches in high forest [ton/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **ton_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for the whole tree in high forest (tops, branches and stem) in ton/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **ton_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;BEF for tops and branches for Coppices in ton/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.28*  
    **econ_bioenergy** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy [Mwh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **net_revenues** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the net present value [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *net_revenues*  
    **total_revenues** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the total revenues [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **total_cost** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the total cost [EUR/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **econ_bioenergyhf** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy in high forest [Mwh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **econ_bioenergyc** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map with the financial potential of bioenergy for coppices[Mwh/year]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Compute the biomass forestry residual potential considering the economic
constraints.

## NOTES

## EXAMPLE

## REFERENCE

## SEE ALSO

*[r.green](r.green.md), [r.green.biomassfor](r.green.biomassfor.md)*

## AUTHORS

Francesco Geri, Pietro Zambelli, Sandro Sacchelli, Marco Ciolli  
Code rewritten by Giulia Garegnani

## SOURCE CODE

Available at: [r.green.biomassfor.financial source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.biomassfor/r.green.biomassfor.financial)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.biomassfor/r.green.biomassfor.financial))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
