---
name: r.green.biomassfor.technical.py
description: Estimates the quantity of woody biomass obtained from a forest surface where extraction is possible given a particular level of mechanisation
keywords: [ raster, biomass ]
---

# r.green.biomassfor.technical.py

Estimates the quantity of woody biomass obtained from a forest surface where extraction is possible given a particular level of mechanisation

=== "Command line"

    **r.green.biomassfor.technical.py**
    [**-r**]
    **dtm**=*name*
    **forest**=*name*
    **boundaries**=*name*
    **forest_column_yield**=*string*
    **forest_column_yield_surface**=*string*
    **forest_column_management**=*string*
    **forest_column_treatment**=*string*
    **forest_roads**=*name*
    **output_basename**=*name*
    [**forest_column_roughness**=*string*]
    [**rivers**=*name*]
    [**lakes**=*name*]
    [**slp_min_cc**=*float*]
    [**slp_max_cc**=*float*]
    [**dist_max_cc**=*float*]
    [**slp_max_fw**=*float*]
    [**dist_max_fw**=*float*]
    [**slp_max_cop**=*float*]
    [**dist_max_cop**=*float*]
    [**energy_tops_hf**=*float*]
    [**energy_cormometric_vol_hf**=*float*]
    [**energy_tops_cop**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.green.biomassfor.technical.py dtm=name forest=name boundaries=name forest_column_yield=string forest_column_yield_surface=string forest_column_management=string forest_column_treatment=string forest_roads=name output_basename=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.green.biomassfor.technical.py***",
        **dtm**,
        **forest**,
        **boundaries**,
        **forest_column_yield**,
        **forest_column_yield_surface**,
        **forest_column_management**,
        **forest_column_treatment**,
        **forest_roads**,
        **output_basename**,
        **forest_column_roughness**=*None*,
        **rivers**=*None*,
        **lakes**=*None*,
        **slp_min_cc**=*30.*,
        **slp_max_cc**=*100.*,
        **dist_max_cc**=*800.*,
        **slp_max_fw**=*30.*,
        **dist_max_fw**=*600.*,
        **slp_max_cop**=*30.*,
        **dist_max_cop**=*600.*,
        **energy_tops_hf**=*0.49*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.green.biomassfor.technical.py", dtm="name", forest="name", boundaries="name", forest_column_yield="string", forest_column_yield_surface="string", forest_column_management="string", forest_column_treatment="string", forest_roads="name", output_basename="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_green_biomassfor_technical_py*(**dtm**,
        **forest**,
        **boundaries**,
        **forest_column_yield**,
        **forest_column_yield_surface**,
        **forest_column_management**,
        **forest_column_treatment**,
        **forest_roads**,
        **output_basename**,
        **forest_column_roughness**=*None*,
        **rivers**=*None*,
        **lakes**=*None*,
        **slp_min_cc**=*30.*,
        **slp_max_cc**=*100.*,
        **dist_max_cc**=*800.*,
        **slp_max_fw**=*30.*,
        **dist_max_fw**=*600.*,
        **slp_max_cop**=*30.*,
        **dist_max_cop**=*600.*,
        **energy_tops_hf**=*0.49*,
        **energy_cormometric_vol_hf**=*1.97*,
        **energy_tops_cop**=*0.55*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_green_biomassfor_technical_py(dtm="name", forest="name", boundaries="name", forest_column_yield="string", forest_column_yield_surface="string", forest_column_management="string", forest_column_treatment="string", forest_roads="name", output_basename="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dtm**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Digital terrain model map  
    **forest**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    **boundaries**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    **forest_column_yield**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_roads**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    **output_basename**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for technical bioenergy (HF,CC and total)  
    **forest_column_roughness**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **rivers**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    **lakes**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    **slp_min_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **energy_tops_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for the whole tree in high forest (tops, branches and stem) in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dtm** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Digital terrain model map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **boundaries** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_yield** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output_basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for technical bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **rivers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **slp_min_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for the whole tree in high forest (tops, branches and stem) in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dtm** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Digital terrain model map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **forest** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector parcel map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **boundaries** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector boundaries map (boolean map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **forest_column_yield** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of yield  
    **forest_column_yield_surface** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of stand surface (ha)  
    **forest_column_management** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest management (1: high forest, 2:coppice)  
    **forest_column_treatment** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of forest treatment (1: final felling, 2:thinning)  
    **forest_roads** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of forest roads  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output_basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for technical bioenergy (HF,CC and total)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, , *name*  
    **forest_column_roughness** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector field of roughness  
    **rivers** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of rivers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **lakes** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map of lakes  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **slp_min_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope lower limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **slp_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **dist_max_cc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Cable Crane  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800.*  
    **slp_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_fw** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with Forwarder  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **slp_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent slope higher limit with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30.*  
    **dist_max_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance with other techniques for Coppices  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600.*  
    **energy_tops_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches in high forest in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.49*  
    **energy_cormometric_vol_hf** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for the whole tree in high forest (tops, branches and stem) in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.97*  
    **energy_tops_cop** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Energy for tops and branches for Coppices in MWh/m3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.55*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove all operational maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Compute the biomass forestry residual potential considering the
technical constraints of different harvesting techniques.

## NOTES

## EXAMPLE

## REFERENCE

## SEE ALSO

*[r.green](r.green.md), [r.green.biomassfor](r.green.biomassfor.md)*

## AUTHORS

Francesco Geri, Pietro Zambelli, Sandro Sacchelli, Marco Ciolli

## SOURCE CODE

Available at: [r.green.biomassfor.technical source code](https://github.com/OSGeo/grass-addons/tree/grass8/r.green/r.green.biomassfor/r.green.biomassfor.technical)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/r.green/r.green.biomassfor/r.green.biomassfor.technical))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
