---
name: r.jpdf
description: From two series of input raster maps, calculates the joint probability function and outputs the probabilities of occurrence in the specified bins.
keywords: [ raster, series ]
---

# r.jpdf

From two series of input raster maps, calculates the joint probability function and outputs the probabilities of occurrence in the specified bins.

=== "Command line"

    **r.jpdf**
    [**-q**]
    **output**=*name*
    **input1**=*string* [,*string*,...]
    **input2**=*string* [,*string*,...]
    **bins1**=*string* [,*string*,...]
    **bins2**=*string* [,*string*,...]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.jpdf output=name input1=string input2=string bins1=string bins2=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.jpdf***",
        **output**,
        **input1**,
        **input2**,
        **bins1**,
        **bins2**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.jpdf", output="name", input1="string", input2="string", bins1="string", bins2="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_jpdf*(**output**,
        **input1**,
        **input2**,
        **bins1**,
        **bins2**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_jpdf(output="name", input1="string", input2="string", bins1="string", bins2="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix of output raster name, will be followed by bin numbers  
    **input1**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;First set of input rasters  
    **input2**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Second set of input rasters  
    **bins1**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start value, end value, and number of bins for first independent variable (from first set of inputs)  
    **bins2**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start value, end value, and number of bins for second independent variable (from second set of inputs)  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Run quietly  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix of output raster name, will be followed by bin numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **input1** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;First set of input rasters  
    **input2** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Second set of input rasters  
    **bins1** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start value, end value, and number of bins for first independent variable (from first set of inputs)  
    **bins2** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start value, end value, and number of bins for second independent variable (from second set of inputs)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *q*  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Run quietly  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix of output raster name, will be followed by bin numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **input1** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;First set of input rasters  
    **input2** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Second set of input rasters  
    **bins1** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start value, end value, and number of bins for first independent variable (from first set of inputs)  
    **bins2** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start value, end value, and number of bins for second independent variable (from second set of inputs)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *q*  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Run quietly  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.jpdf* reads two series of raster maps and calculates for each raster
cell the joint probability density function of the two input series. The
output is set of raster maps, each containing the probability within a
range of values from the first set and a range from the second set. NULL
values are ignored when calculating the JPDF.

The number of output raster maps is determined by the number of "bins"
specified by the user using the parameters *input1* and *input2*. The
users gives the range and density of bins with
*input1=Start1,End1,Nbins1 input2=Start2,End2,Nbins2*. In this case the
data from the first data set will be assigned to *Nbins1* intervals
between *Start1* and *End1* and *Nbins2* intervals between *Start2* and
*End2* for the second data set. In addition, *r.jpdf* will calculate
extra bins for values below or above the start and end values given by
the user. In total, the output will consist of (*Nbins1*+2)×(*Nbins2*+2)
raster maps. The naming of the output rasters is *Prefix\_N1\_N2* where
*Prefix* is given by the parameter *output*. *N1* and *N2* may contain
leading zeros.

## NOTES

### Input series of different lengths

Rasters from the two series of input data will be compared in the order
in which they appear in the two lists. If one list is longer than the
other, the trailing raster maps will be ignored.

### Memory consumption

The (*Nbins1*+2)×(*Nbins2*+2) raster maps are held in memory until the
end of the processing. On the other hand, only one raster from each of
the two series of input rasters will be held in memory.

## EXAMPLES

Using *r.jpdf* with wildcards:  

```sh
r.series input1="`g.list pattern='temperature*' sep=,`" input2="`g.list pattern='pressure*' sep=,`"\
         output=jpdf_temp_pres bins1=-20,40,10 bins2=950,1030,10
```

Note the *g.list* script also supports regular expressions for selecting
map names.

## SEE ALSO

*[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html),
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r.quantile](https://grass.osgeo.org/grass-stable/manuals/r.quantile.html),
[r.series.accumulate](https://grass.osgeo.org/grass-stable/manuals/r.series.accumulate.html),
[r.series.interp](https://grass.osgeo.org/grass-stable/manuals/r.series.interp.html),
[r.univar](https://grass.osgeo.org/grass-stable/manuals/r.univar.html)*

[Hints for large raster data
processing](https://grasswiki.osgeo.org/wiki/Large_raster_data_processing)

## AUTHOR

Thomas Huld

## SOURCE CODE

Available at: [r.jpdf source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.jpdf)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.jpdf))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
