---
name: r.mask.status
description: Reports presence or absence of a raster mask Provides information about the presence of a 2D raster mask as text output or return code
keywords: [ raster, mask, reclassification ]
---

# r.mask.status

Reports presence or absence of a raster mask

Provides information about the presence of a 2D raster mask as text output or return code

=== "Command line"

    **r.mask.status**
    [**-t**]
    [**format**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mask.status
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.mask.status***",
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.mask.status", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mask_status*(**format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mask_status(format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format for reporting  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell, yaml*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**yaml**: YAML (human-friendly data serialization language)  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Return code 0 when mask present, 1 otherwise  
    &nbsp;&nbsp;&nbsp;&nbsp;Behave like the test utility, 0 for true, 1 for false, no output  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format for reporting  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell, yaml*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**yaml**: YAML (human-friendly data serialization language)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return code 0 when mask present, 1 otherwise  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Behave like the test utility, 0 for true, 1 for false, no output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Format for reporting  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell, yaml*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**yaml**: YAML (human-friendly data serialization language)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return code 0 when mask present, 1 otherwise  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Behave like the test utility, 0 for true, 1 for false, no output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *r.mask.status* reports information about the 2D raster mask and its
status. The tool reports whether the mask is present or not. For both
active and inactive mask, the tool reports a full name of the raster
(name including the mapset) which represents or would represent the
mask. It can also report full name of the underlying raster if the mask
is reclassified from another raster. The tool can be used to check if
the mask is currently set (`present` boolean in JSON), what is raster
name used to represent the mask (`name` string in JSON), and whether the
raster is reclassifed from another (`is_reclass_of` string or null in
JSON). YAML and shell script style outputs are following the JSON output
if possible. The plain text format outputs multi-line human-readable
information in natural language.

With the **-t** flag, no output is printed, instead a return code is
used to indicate presence or absence. The convention is the same same
the POSIX *test* utility, so *r.mask.status* returns 0 when the mask is
present and 1 otherwise.

## EXAMPLES

### Generate JSON output

To generate JSON output in Bash, use the **format** option:

```sh
r.mask.status format=json
```

In Python, use:

```python
import grass.script as gs
gs.parse_command("r.mask.status", format="json")
```

This returns a dictionary with keys `present`, `full_name`, and
`is_reclass_of`.

### Use as the test utility

The POSIX *test* utility uses return code 0 to indicate presence and 1
to indicate absence of a file, so testing existence of a file with
`test -f` gives return code 0 when the file exists. *r.mask.status* can
be used in the same with the **-t** flag:

```sh
r.mask.status -t
```

In a Bash script:

```sh
# Bash
if r.mask.status -t; then
    echo "Masking is active"
else
    echo "Masking is not active"
fi
```

## SEE ALSO

*[r.mask](r.mask.md), [g.region](g.region.md)*

## AUTHORS

Vaclav Petras, NC State University, Center for Geospatial Analytics

## SOURCE CODE

Available at: [r.mask.status source code](https://github.com/OSGeo/grass/tree/main/raster/r.mask.status)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.mask.status))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
